/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.NBTSerializable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class NBTUtilsJS {
    @Nullable
    public static MapJS read(File file) throws IOException {
        KubeJS.verifyFilePath(file);
        if (!file.exists()) {
            return null;
        }
        return MapJS.of(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
    }

    public static void write(File file, @Nullable MapJS nbt) throws IOException {
        KubeJS.verifyFilePath(file);
        if (nbt == null) {
            file.delete();
            return;
        }
        CompressedStreamTools.func_74799_a((CompoundNBT)nbt.toNBT(), (OutputStream)new FileOutputStream(file));
    }

    @Nullable
    public static MapJS read(String file) throws IOException {
        return NBTUtilsJS.read(KubeJS.getGameDirectory().resolve(file).toFile());
    }

    public static void write(String file, @Nullable MapJS nbt) throws IOException {
        NBTUtilsJS.write(KubeJS.getGameDirectory().resolve(file).toFile(), nbt);
    }

    @Nullable
    public static INBT toNBT(@Nullable Object o) {
        if (o instanceof NBTSerializable) {
            return ((NBTSerializable)o).toNBT();
        }
        if (o instanceof String || o instanceof Character) {
            return StringNBT.func_229705_a_((String)o.toString());
        }
        if (o instanceof Boolean) {
            return ByteNBT.func_229671_a_((byte)((Boolean)o != false ? (byte)1 : 0));
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Byte) {
                return ByteNBT.func_229671_a_((byte)number.byteValue());
            }
            if (number instanceof Short) {
                return ShortNBT.func_229701_a_((short)number.shortValue());
            }
            if (number instanceof Integer) {
                return IntNBT.func_229692_a_((int)number.intValue());
            }
            if (number instanceof Float) {
                return FloatNBT.func_229689_a_((float)number.floatValue());
            }
            return DoubleNBT.func_229684_a_((double)number.doubleValue());
        }
        return null;
    }
}

