/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextString;
import dev.latvian.kubejs.text.TextTranslate;
import dev.latvian.kubejs.util.Copyable;
import dev.latvian.kubejs.util.FieldJS;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.WrappedJS;
import dev.latvian.kubejs.world.WorldJS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effect;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UtilsJS {
    public static final Pattern REGEX_PATTERN = Pattern.compile("\\/(.*)\\/([a-z]*)");
    public static final Random RANDOM = new Random();

    @Nullable
    public static Pattern regex(String string, boolean strong) {
        Matcher matcher = REGEX_PATTERN.matcher(string);
        if (matcher.find()) {
            int flags = 0;
            String f = matcher.group(2);
            block9: for (int i = 0; i < f.length(); ++i) {
                switch (f.charAt(i)) {
                    case 'd': {
                        flags |= 1;
                        continue block9;
                    }
                    case 'i': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block9;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block9;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'u': {
                        flags |= 0x40;
                        continue block9;
                    }
                    case 'U': {
                        flags |= 0x100;
                    }
                }
            }
            return Pattern.compile(matcher.group(1), flags);
        }
        if (!strong) {
            return Pattern.compile(string);
        }
        return null;
    }

    public static void init() {
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static void queueIO(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static File getFile(String path) throws IOException {
        Path path1 = KubeJS.getGameDirectory().resolve(path);
        KubeJS.verifyFilePath(path1);
        return path1.toFile();
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        if (o instanceof Copyable) {
            return ((Copyable)o).copy();
        }
        if (o instanceof JsonElement) {
            return JsonUtilsJS.copy((JsonElement)o);
        }
        if (o instanceof INBT) {
            return ((INBT)o).func_74737_b();
        }
        return o;
    }

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return o.toString();
        }
        if (o instanceof ITextComponent) {
            TextString t = new TextString("");
            for (ITextComponent c : (ITextComponent)o) {
                HoverEvent he;
                Text t1 = c instanceof TranslationTextComponent ? new TextTranslate(((TranslationTextComponent)c).func_150268_i(), ((TranslationTextComponent)c).func_150271_j()) : new TextString(c.func_150261_e());
                t1.bold(c.func_150256_b().func_150223_b());
                t1.italic(c.func_150256_b().func_150242_c());
                t1.underlined(c.func_150256_b().func_150234_e());
                t1.strikethrough(c.func_150256_b().func_150236_d());
                t1.obfuscated(c.func_150256_b().func_150233_f());
                t1.insertion(c.func_150256_b().func_179986_j());
                ClickEvent ce = c.func_150256_b().func_150235_h();
                if (ce != null) {
                    if (ce.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                        t1.click("command:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                        t1.click("suggest_command:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                        t1.click("copy:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                        t1.click(ce.func_150668_b());
                    }
                }
                if ((he = c.func_150256_b().func_150210_i()) != null && he.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                    t1.hover(Text.of(he.func_150702_b()));
                }
                t.append(t1);
            }
            return t;
        }
        if (o instanceof JSObject) {
            JSObject js = (JSObject)o;
            if (js.isFunction()) {
                return js;
            }
            if (js.isArray()) {
                if (!type.checkList()) {
                    return null;
                }
                ListJS list = new ListJS(js.values().size());
                list.addAll(js.values());
                return list;
            }
            if (type.checkMap()) {
                MapJS map = new MapJS();
                for (String k : ((JSObject)o).keySet()) {
                    map.put(k, ((JSObject)o).getMember(k));
                }
                return map;
            }
            return null;
        }
        if (o instanceof ScriptObject) {
            ScriptObject js = (ScriptObject)o;
            if (js instanceof ScriptFunction) {
                return js;
            }
            if (js.isArray()) {
                if (!type.checkList()) {
                    return null;
                }
                ListJS list = new ListJS(js.size());
                list.addAll(js.values());
                return list;
            }
            if (type.checkMap()) {
                MapJS map = new MapJS(js.size());
                for (Object k : js.keySet()) {
                    map.put(k.toString(), js.get(k));
                }
                return map;
            }
            return null;
        }
        if (o instanceof Map) {
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(((Map)o).size());
            map.putAll((Map)o);
            return map;
        }
        if (o instanceof Iterable) {
            if (!type.checkList()) {
                return null;
            }
            ListJS list = new ListJS();
            for (Object o1 : (Iterable)o) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            return JsonUtilsJS.toPrimitive((JsonElement)((JsonPrimitive)o));
        }
        if (o instanceof JsonObject) {
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(((JsonObject)o).size());
            for (Map.Entry entry : ((JsonObject)o).entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        if (o instanceof JsonNull || o instanceof EndNBT) {
            return null;
        }
        if (o instanceof CompoundNBT) {
            if (!type.checkMap()) {
                return null;
            }
            CompoundNBT nbt = (CompoundNBT)o;
            MapJS map = new MapJS(nbt.func_186856_d());
            for (String s : nbt.func_150296_c()) {
                map.put(s, (Object)nbt.func_74781_a(s));
            }
            return map;
        }
        if (o instanceof NumberNBT) {
            return ((NumberNBT)o).func_209908_j();
        }
        if (o instanceof StringNBT) {
            return ((StringNBT)o).func_150285_a_();
        }
        return o;
    }

    public static <T> FieldJS<T> getField(String className, String fieldName) {
        try {
            return UtilsJS.getField(Class.forName(className), fieldName);
        }
        catch (Throwable ex) {
            return new FieldJS(null);
        }
    }

    public static <T> FieldJS<T> getField(Class className, String fieldName) {
        try {
            return new FieldJS(ObfuscationReflectionHelper.findField((Class)className, (String)fieldName));
        }
        catch (Throwable ex) {
            return new FieldJS(null);
        }
    }

    public static int parseInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Double.parseDouble(String.valueOf(object));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static Stat<ResourceLocation> getStat(@ID String id) {
        return Stats.field_199092_j.func_199076_b((Object)UtilsJS.getMCID(id));
    }

    public static ToolType getToolType(String id) {
        return ToolType.get((String)id);
    }

    public static WorldJS getWorld(IWorld world) {
        if (world.func_201670_d()) {
            return UtilsJS.getClientWorld();
        }
        return ServerJS.instance.getWorld(world);
    }

    public static WorldJS getClientWorld() {
        return KubeJS.instance.proxy.getClientWorld();
    }

    @Nullable
    public static Effect getPotion(@ID String id) {
        return (Effect)ForgeRegistries.POTIONS.getValue(UtilsJS.getMCID(id));
    }

    @ID
    public static String getID(@ID @Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft:air";
        }
        if (s.indexOf(58) == -1) {
            return "minecraft:" + s;
        }
        return s;
    }

    public static ResourceLocation getMCID(@ID @Nullable String s) {
        if (s == null || s.isEmpty()) {
            return new ResourceLocation("minecraft:air");
        }
        return new ResourceLocation(s);
    }

    public static String getNamespace(@ID @Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String getPath(@ID @Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static <T extends IForgeRegistryEntry<T>> Function<ResourceLocation, Optional<T>> valueGetter(IForgeRegistry<T> registry, @Nullable T def) {
        return id -> {
            IForgeRegistryEntry value = registry.getValue(id);
            if (value != null && value != def) {
                return Optional.of(value);
            }
            return Optional.empty();
        };
    }
}

