/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.item.InventoryJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.ExplosionJS;
import dev.latvian.kubejs.world.FireworksJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockContainerJS {
    private static final ResourceLocation AIR_ID = new ResourceLocation("minecraft:air");
    public final IWorld minecraftWorld;
    private final BlockPos pos;
    private BlockState cachedState;
    private TileEntity cachedEntity;

    public BlockContainerJS(IWorld w, BlockPos p) {
        this.minecraftWorld = w;
        this.pos = p;
    }

    public void clearCache() {
        this.cachedState = null;
        this.cachedEntity = null;
    }

    public WorldJS getWorld() {
        return UtilsJS.getWorld(this.minecraftWorld);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.minecraftWorld.func_201675_m().func_186058_p().func_186068_a();
    }

    public int getX() {
        return this.getPos().func_177958_n();
    }

    public int getY() {
        return this.getPos().func_177956_o();
    }

    public int getZ() {
        return this.getPos().func_177952_p();
    }

    public BlockContainerJS offset(Direction f, int d) {
        return new BlockContainerJS(this.minecraftWorld, this.getPos().func_177967_a(f, d));
    }

    public BlockContainerJS offset(Direction f) {
        return this.offset(f, 1);
    }

    public BlockContainerJS offset(int x, int y, int z) {
        return new BlockContainerJS(this.minecraftWorld, this.getPos().func_177982_a(x, y, z));
    }

    public BlockContainerJS getDown() {
        return this.offset(Direction.DOWN);
    }

    public BlockContainerJS getUp() {
        return this.offset(Direction.UP);
    }

    public BlockContainerJS getNorth() {
        return this.offset(Direction.NORTH);
    }

    public BlockContainerJS getSouth() {
        return this.offset(Direction.SOUTH);
    }

    public BlockContainerJS getWest() {
        return this.offset(Direction.WEST);
    }

    public BlockContainerJS getEast() {
        return this.offset(Direction.EAST);
    }

    @MinecraftClass
    public BlockState getBlockState() {
        if (this.cachedState == null) {
            this.cachedState = this.minecraftWorld.func_180495_p(this.getPos());
        }
        return this.cachedState;
    }

    @MinecraftClass
    public void setBlockState(BlockState state, int flags) {
        this.minecraftWorld.func_180501_a(this.getPos(), state, flags);
        this.clearCache();
    }

    @ID
    public String getId() {
        return this.getBlockState().func_177230_c().getRegistryName().toString();
    }

    public void set(@ID String id, Map<?, ?> properties, int flags) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(UtilsJS.getMCID(id));
        BlockState state = (block == null ? Blocks.field_150350_a : block).func_176223_P();
        if (!properties.isEmpty() && state.func_177230_c() != Blocks.field_150350_a) {
            HashMap<String, IProperty> pmap = new HashMap<String, IProperty>();
            for (IProperty iProperty : state.func_206869_a()) {
                pmap.put(iProperty.func_177701_a(), iProperty);
            }
            for (Map.Entry entry : properties.entrySet()) {
                IProperty property = (IProperty)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (BlockState)state.func_206870_a(property, (Comparable)UtilsJS.cast(property.func_185929_b(String.valueOf(entry.getValue())).get()));
            }
        }
        this.setBlockState(state, flags);
    }

    public void set(@ID String id, Map<?, ?> properties) {
        this.set(id, properties, 3);
    }

    public void set(@ID String id) {
        this.set(id, Collections.emptyMap());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        BlockState state = this.getBlockState();
        for (IProperty property : state.func_206869_a()) {
            map.put(property.func_177701_a(), property.func_177702_a(state.func_177229_b(property)));
        }
        return map;
    }

    @Nullable
    @MinecraftClass
    public TileEntity getEntity() {
        if (this.cachedEntity == null || this.cachedEntity.func_145837_r()) {
            this.cachedEntity = this.minecraftWorld.func_175625_s(this.pos);
        }
        return this.cachedEntity;
    }

    @ID
    public String getEntityId() {
        TileEntity entity = this.getEntity();
        return entity == null ? "minecraft:air" : entity.func_200662_C().getRegistryName().toString();
    }

    @Nullable
    public MapJS getEntityData() {
        MapJS entityData;
        TileEntity entity = this.getEntity();
        if (entity != null && (entityData = MapJS.of(entity.serializeNBT())) != null) {
            entityData.changeListener = o -> entity.deserializeNBT(MapJS.nbt(o));
            return entityData;
        }
        return null;
    }

    public int getLight() {
        return this.minecraftWorld.func_201696_r(this.pos);
    }

    public boolean getCanSeeSky() {
        return this.minecraftWorld.func_175710_j(this.pos);
    }

    public String toString() {
        String id = this.getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id;
        }
        StringBuilder builder = new StringBuilder(id);
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public ExplosionJS createExplosion() {
        return new ExplosionJS(this.minecraftWorld, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    @Nullable
    public EntityJS createEntity(@ID String id) {
        EntityJS entity = this.getWorld().createEntity(id);
        if (entity != null) {
            entity.setPosition(this);
        }
        return entity;
    }

    public void spawnLightning(boolean effectOnly) {
        if (this.minecraftWorld instanceof ServerWorld) {
            ((ServerWorld)this.minecraftWorld).func_217468_a(new LightningBoltEntity((World)((ServerWorld)this.minecraftWorld), (double)this.getX(), (double)this.getY(), (double)this.getZ(), effectOnly));
        }
    }

    public void spawnFireworks(FireworksJS fireworks) {
        if (this.minecraftWorld instanceof World) {
            this.minecraftWorld.func_217376_c((Entity)fireworks.createFireworkRocket((World)this.minecraftWorld, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5));
        }
    }

    @Nullable
    public InventoryJS getInventory(Direction facing) {
        IItemHandler handler;
        TileEntity tileEntity = this.getEntity();
        if (tileEntity != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null)) != null) {
            return new InventoryJS(handler);
        }
        return null;
    }

    public MaterialJS getMaterial() {
        return MaterialListJS.INSTANCE.get(this.getBlockState().func_185904_a());
    }

    public ItemStackJS getItem() {
        BlockState state = this.getBlockState();
        return ItemStackJS.of(state.func_177230_c().func_185473_a((IBlockReader)this.minecraftWorld, this.pos, state));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence || obj instanceof ResourceLocation) {
            return this.getId().equals(obj.toString());
        }
        return super.equals(obj);
    }
}

