/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.core.ExplosionKJS;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.WorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.ExplosionEvent;

public abstract class ExplosionEventJS
extends WorldEventJS {
    private final ExplosionEvent event;

    private ExplosionEventJS(ExplosionEvent e) {
        this.event = e;
    }

    @Override
    public WorldJS getWorld() {
        return this.worldOf((IWorld)this.event.getWorld());
    }

    public Vec3d getPosition() {
        return this.event.getExplosion().getPosition();
    }

    public double getX() {
        return this.getPosition().field_72450_a;
    }

    public double getY() {
        return this.getPosition().field_72448_b;
    }

    public double getZ() {
        return this.getPosition().field_72449_c;
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS((IWorld)this.event.getWorld(), new BlockPos(this.event.getExplosion().getPosition()));
    }

    @Nullable
    public LivingEntityJS getExploder() {
        return this.getWorld().getLivingEntity((Entity)this.event.getExplosion().func_94613_c());
    }

    public static class Post
    extends ExplosionEventJS {
        private final ExplosionEvent.Detonate event;

        public Post(ExplosionEvent.Detonate e) {
            super((ExplosionEvent)e);
            this.event = e;
        }

        public EntityArrayList getAffectedEntities() {
            return new EntityArrayList(this.getWorld(), this.event.getAffectedEntities());
        }

        public void removeAffectedEntity(EntityJS entity) {
            this.event.getAffectedEntities().remove(entity.minecraftEntity);
        }

        public void removeAllAffectedEntities() {
            this.event.getAffectedEntities().clear();
        }

        public List<BlockContainerJS> getAffectedBlocks() {
            ArrayList<BlockContainerJS> list = new ArrayList<BlockContainerJS>(this.event.getAffectedBlocks().size());
            for (BlockPos pos : this.event.getAffectedBlocks()) {
                list.add(new BlockContainerJS((IWorld)this.event.getWorld(), pos));
            }
            return list;
        }

        public void removeAffectedBlock(BlockContainerJS block) {
            this.event.getAffectedBlocks().remove(block.getPos());
        }

        public void removeAllAffectedBlocks() {
            this.event.getAffectedBlocks().clear();
        }

        public void removeKnockback() {
            this.event.getExplosion().func_77277_b().clear();
        }
    }

    public static class Pre
    extends ExplosionEventJS {
        private final ExplosionEvent.Start event;

        public Pre(ExplosionEvent.Start e) {
            super((ExplosionEvent)e);
            this.event = e;
        }

        @Override
        public boolean canCancel() {
            return true;
        }

        public float getSize() {
            return ((ExplosionKJS)this.event.getExplosion()).getSizeKJS();
        }

        public void setSize(float s) {
            ((ExplosionKJS)this.event.getExplosion()).setSizeKJS(s);
        }
    }
}

