/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.core.FireworkRocketEntityKJS;
import dev.latvian.kubejs.text.TextColor;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class FireworksJS {
    public int flight = 2;
    public int lifetime = -1;
    public final List<Explosion> explosions = new ArrayList<Explosion>();

    public static FireworksJS of(Object o) {
        MapJS properties = MapJS.of(o);
        FireworksJS fireworks = new FireworksJS();
        if (properties == null) {
            return fireworks;
        }
        if (properties.get("flight") instanceof Number) {
            fireworks.flight = ((Number)properties.get("flight")).intValue();
        }
        if (properties.get("lifeTime") instanceof Number) {
            fireworks.lifetime = ((Number)properties.get("lifeTime")).intValue();
        }
        if (properties.containsKey("explosions")) {
            for (Object o1 : ListJS.orSelf(properties.get("explosions"))) {
                MapJS m = MapJS.of(o1);
                if (m == null) continue;
                Explosion e = new Explosion();
                if (m.get("shape") instanceof String) {
                    e.shape = Shape.get(m.get("shape").toString());
                }
                if (m.get("flicker") instanceof Boolean) {
                    e.flicker = (Boolean)m.get("flicker");
                }
                if (m.get("trail") instanceof Boolean) {
                    e.trail = (Boolean)m.get("trail");
                }
                if (m.containsKey("colors")) {
                    for (Object o2 : ListJS.orSelf(m.get("colors"))) {
                        if (o2 instanceof Number) {
                            e.colors.add(((Number)o2).intValue());
                            continue;
                        }
                        if (o2 instanceof TextColor) {
                            e.colors.add(((TextColor)((Object)o2)).color);
                            continue;
                        }
                        if (!(o2 instanceof String)) continue;
                        e.colors.add(DyeColor.valueOf((String)o2.toString()).getColorValue());
                    }
                }
                if (m.containsKey("fadeColors")) {
                    for (Object o2 : ListJS.orSelf(m.get("fadeColors"))) {
                        if (o2 instanceof Number) {
                            e.fadeColors.add(((Number)o2).intValue());
                            continue;
                        }
                        if (o2 instanceof TextColor) {
                            e.fadeColors.add(((TextColor)((Object)o2)).color);
                            continue;
                        }
                        if (!(o2 instanceof String)) continue;
                        e.fadeColors.add(DyeColor.valueOf((String)o2.toString()).getColorValue());
                    }
                }
                if (e.colors.isEmpty()) {
                    e.colors.add(TextColor.YELLOW.color);
                }
                fireworks.explosions.add(e);
            }
        }
        if (fireworks.explosions.isEmpty()) {
            Explosion e = new Explosion();
            e.colors.add(TextColor.YELLOW.color);
            fireworks.explosions.add(e);
        }
        return fireworks;
    }

    public FireworkRocketEntity createFireworkRocket(World w, double x, double y, double z) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Flight", this.flight);
        ListNBT list = new ListNBT();
        for (Explosion e : this.explosions) {
            CompoundNBT nbt1 = new CompoundNBT();
            nbt1.func_74768_a("Type", e.shape.type);
            nbt1.func_74757_a("Flicker", e.flicker);
            nbt1.func_74757_a("Trail", e.trail);
            nbt1.func_74783_a("Colors", e.colors.toIntArray());
            nbt1.func_74783_a("FadeColors", e.fadeColors.toIntArray());
            list.add((Object)nbt1);
        }
        nbt.func_218657_a("Explosions", (INBT)list);
        stack.func_77983_a("Fireworks", (INBT)nbt);
        FireworkRocketEntity rocket = new FireworkRocketEntity(w, x, y, z, stack);
        if (this.lifetime != -1) {
            ((FireworkRocketEntityKJS)rocket).setLifetimeKJS(this.lifetime);
        }
        rocket.func_82142_c(true);
        return rocket;
    }

    public static class Explosion {
        public Shape shape = Shape.SMALL_BALL;
        public boolean flicker = false;
        public boolean trail = false;
        public final IntOpenHashSet colors = new IntOpenHashSet();
        public final IntOpenHashSet fadeColors = new IntOpenHashSet();
    }

    public static enum Shape {
        SMALL_BALL("small_ball", 0),
        LARGE_BALL("large_ball", 1),
        STAR("star", 2),
        CREEPER("creeper", 3),
        BURST("burst", 4);

        public static final Shape[] VALUES;
        private final String name;
        public final int type;

        private Shape(String n2, int t) {
            this.name = n2;
            this.type = t;
        }

        public static Shape get(String name) {
            for (Shape s : VALUES) {
                if (!s.name.equals(name)) continue;
                return s;
            }
            return SMALL_BALL;
        }

        static {
            VALUES = Shape.values();
        }
    }
}

