/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.block.MissingMappingEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ExplosionEventJS;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.SimpleWorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class KubeJSWorldEventHandler {
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::worldLoaded);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::worldUnloaded);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::worldTick);
        MinecraftForge.EVENT_BUS.addListener(this::explosionStart);
        MinecraftForge.EVENT_BUS.addListener(this::explosionDetonate);
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, this::missingBlockMappings);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, this::missingItemMappings);
    }

    private void worldLoaded(WorldEvent.Load event) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && event.getWorld() instanceof ServerWorld && !ServerJS.instance.worldMap.containsKey(event.getWorld().func_201675_m().func_186058_p())) {
            ServerWorldJS w = new ServerWorldJS(ServerJS.instance, (ServerWorld)event.getWorld());
            ServerJS.instance.worldMap.put(event.getWorld().func_201675_m().func_186058_p(), w);
            ServerJS.instance.updateWorldList();
            MinecraftForge.EVENT_BUS.post((Event)new AttachWorldDataEvent(w));
            new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.load");
        }
    }

    private void worldUnloaded(WorldEvent.Unload event) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && event.getWorld() instanceof ServerWorld && ServerJS.instance.worldMap.containsKey(event.getWorld().func_201675_m().func_186058_p())) {
            WorldJS w = ServerJS.instance.getWorld(event.getWorld());
            new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.unload");
            ServerJS.instance.worldMap.remove(w.getDimension());
            ServerJS.instance.updateWorldList();
        }
    }

    private void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            WorldJS w = ServerJS.instance.getWorld((IWorld)event.world);
            new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.tick");
        }
    }

    private void explosionStart(ExplosionEvent.Start event) {
        if (new ExplosionEventJS.Pre(event).post("world.explosion.pre")) {
            event.setCanceled(true);
        }
    }

    private void explosionDetonate(ExplosionEvent.Detonate event) {
        new ExplosionEventJS.Post(event).post("world.explosion.post");
    }

    private void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        new MissingMappingEventJS<Block>(event, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).post(ScriptType.STARTUP, "block.missing_mappings");
    }

    private void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        new MissingMappingEventJS<Item>(event, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).post(ScriptType.STARTUP, "item.missing_mappings");
    }
}

