/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.world.WorldCommandSender;
import dev.latvian.kubejs.world.WorldJS;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ServerWorldJS
extends WorldJS {
    private final ServerJS server;

    public ServerWorldJS(ServerJS s, ServerWorld w) {
        super((World)w);
        this.server = s;
    }

    @Override
    public ScriptType getSide() {
        return ScriptType.SERVER;
    }

    @Override
    public ServerJS getServer() {
        return this.server;
    }

    @Override
    public ServerPlayerDataJS getPlayerData(PlayerEntity player) {
        ServerPlayerDataJS data = this.server.playerMap.get(player.func_110124_au());
        if (data != null) {
            return data;
        }
        FakeServerPlayerDataJS fakeData = this.server.fakePlayerMap.get(player.func_110124_au());
        if (fakeData == null) {
            fakeData = new FakeServerPlayerDataJS(this.server, (ServerPlayerEntity)player);
            MinecraftForge.EVENT_BUS.post((Event)new AttachPlayerDataEvent(fakeData));
        }
        fakeData.player = (ServerPlayerEntity)player;
        return fakeData;
    }

    public String toString() {
        return "ServerWorld:" + this.minecraftWorld.func_201675_m().func_186058_p().getRegistryName();
    }

    @Override
    public EntityArrayList getEntities() {
        return new EntityArrayList((WorldJS)this, ((ServerWorld)this.minecraftWorld).getEntities().collect(Collectors.toList()));
    }

    public EntityArrayList getEntities(String filter) {
        try {
            return this.createEntityList(new EntitySelectorParser(new StringReader(filter), true).func_197400_a().func_197341_b((CommandSource)new WorldCommandSender(this)));
        }
        catch (CommandSyntaxException e) {
            return new EntityArrayList((WorldJS)this, 0);
        }
    }
}

