/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.ItemEntityJS;
import dev.latvian.kubejs.entity.ItemFrameEntityJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.GameRulesJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.util.AttachedData;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WithAttachedData;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.ExplosionJS;
import dev.latvian.kubejs.world.FireworksJS;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class WorldJS
implements WithAttachedData {
    @MinecraftClass
    public final World minecraftWorld;
    private AttachedData data;

    public WorldJS(World w) {
        this.minecraftWorld = w;
    }

    public abstract ScriptType getSide();

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public GameRulesJS getGameRules() {
        return new GameRulesJS(this.minecraftWorld.func_82736_K());
    }

    @Nullable
    public ServerJS getServer() {
        return null;
    }

    public long getSeed() {
        return this.minecraftWorld.func_72905_C();
    }

    public long getTime() {
        return this.minecraftWorld.func_82737_E();
    }

    public long getLocalTime() {
        return this.minecraftWorld.func_72820_D();
    }

    public void setTime(long time) {
        this.minecraftWorld.func_82738_a(time);
    }

    public void setLocalTime(long time) {
        this.minecraftWorld.func_72877_b(time);
    }

    public DimensionType getDimension() {
        return this.minecraftWorld.func_201675_m().func_186058_p();
    }

    public String getDimensionId() {
        return DimensionType.func_212678_a((DimensionType)this.getDimension()).toString();
    }

    public boolean isOverworld() {
        return this.getDimension() == DimensionType.field_223227_a_;
    }

    public boolean isDaytime() {
        return this.minecraftWorld.func_72935_r();
    }

    public boolean isRaining() {
        return this.minecraftWorld.func_72896_J();
    }

    public boolean isThundering() {
        return this.minecraftWorld.func_72911_I();
    }

    public void setRainStrength(float strength) {
        this.minecraftWorld.func_72894_k(strength);
    }

    public BlockContainerJS getBlock(int x, int y, int z) {
        return this.getBlock(new BlockPos(x, y, z));
    }

    public BlockContainerJS getBlock(BlockPos pos) {
        return new BlockContainerJS((IWorld)this.minecraftWorld, pos);
    }

    public BlockContainerJS getBlock(TileEntity blockEntity) {
        return this.getBlock(blockEntity.func_174877_v());
    }

    public abstract PlayerDataJS getPlayerData(PlayerEntity var1);

    @Nullable
    public EntityJS getEntity(@Nullable Entity e) {
        if (e == null) {
            return null;
        }
        if (e instanceof PlayerEntity) {
            return this.getPlayerData((PlayerEntity)e).getPlayer();
        }
        if (e instanceof LivingEntity) {
            return new LivingEntityJS(this, (LivingEntity)e);
        }
        if (e instanceof ItemEntity) {
            return new ItemEntityJS(this, (ItemEntity)e);
        }
        if (e instanceof ItemFrameEntity) {
            return new ItemFrameEntityJS(this, (ItemFrameEntity)e);
        }
        return new EntityJS(this, e);
    }

    @Nullable
    public LivingEntityJS getLivingEntity(@Nullable Entity entity) {
        EntityJS e = this.getEntity(entity);
        return e instanceof LivingEntityJS ? (LivingEntityJS)e : null;
    }

    @Nullable
    public PlayerJS getPlayer(@Nullable Entity entity) {
        EntityJS e = this.getEntity(entity);
        return e instanceof PlayerJS ? (PlayerJS)e : null;
    }

    public EntityArrayList createEntityList(Collection<? extends Entity> entities) {
        return new EntityArrayList(this, entities);
    }

    public EntityArrayList getPlayers() {
        return this.createEntityList(this.minecraftWorld.func_217369_A());
    }

    public EntityArrayList getEntities() {
        return new EntityArrayList(this, 0);
    }

    public ExplosionJS createExplosion(double x, double y, double z) {
        return new ExplosionJS((IWorld)this.minecraftWorld, x, y, z);
    }

    @Nullable
    public EntityJS createEntity(@ID String id) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(UtilsJS.getMCID(id));
        if (type == null) {
            return null;
        }
        return this.getEntity(type.func_200721_a(this.minecraftWorld));
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly) {
        if (this.minecraftWorld instanceof ServerWorld) {
            ((ServerWorld)this.minecraftWorld).func_217468_a(new LightningBoltEntity(this.minecraftWorld, x, y, z, effectOnly));
        }
    }

    public void spawnFireworks(double x, double y, double z, FireworksJS f) {
        this.minecraftWorld.func_217376_c((Entity)f.createFireworkRocket(this.minecraftWorld, x, y, z));
    }
}

