/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.shedaniel.forge.clothconfig2.api.ScissorsHandler;
import me.shedaniel.forge.math.Rectangle;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class ScissorsHandlerImpl
implements ScissorsHandler {
    @Deprecated
    public static final ScissorsHandler INSTANCE = new ScissorsHandlerImpl();
    private final List<Rectangle> scissorsAreas = Lists.newArrayList();

    @Override
    public void clearScissors() {
        this.scissorsAreas.clear();
        this.applyScissors();
    }

    @Override
    public List<Rectangle> getScissorsAreas() {
        return Collections.unmodifiableList(this.scissorsAreas);
    }

    @Override
    public void scissor(Rectangle rectangle) {
        this.scissorsAreas.add(rectangle);
        this.applyScissors();
    }

    @Override
    public void removeLastScissor() {
        if (!this.scissorsAreas.isEmpty()) {
            this.scissorsAreas.remove(this.scissorsAreas.size() - 1);
        }
        this.applyScissors();
    }

    @Override
    public void applyScissors() {
        if (!this.scissorsAreas.isEmpty()) {
            Rectangle r = this.scissorsAreas.get(0).clone();
            this.scissorsAreas.stream().skip(1L).forEach(rectangle -> r.setBounds(r.intersects((Rectangle)rectangle) ? r.intersection((Rectangle)rectangle) : new Rectangle()));
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            double scaleFactor = window.func_198100_s();
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)((double)r.x * scaleFactor)), (int)((int)((double)(window.func_198087_p() - r.height - r.y) * scaleFactor)), (int)((int)((double)r.width * scaleFactor)), (int)((int)((double)r.height * scaleFactor)));
        } else {
            GL11.glDisable((int)3089);
        }
    }
}

