/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Monitor;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.MonitorHandler;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.util.UndeclaredException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@OnlyIn(value=Dist.CLIENT)
public final class MainWindow
implements AutoCloseable {
    private static final Logger field_198114_a = LogManager.getLogger();
    private final GLFWErrorCallback field_198115_b = GLFWErrorCallback.create(this::func_198084_a);
    private final IWindowEventListener field_227797_c_;
    private final MonitorHandler field_216531_d;
    private final long field_198119_f;
    private int field_198120_g;
    private int field_198121_h;
    private int field_198122_i;
    private int field_198123_j;
    private Optional<VideoMode> field_198124_k;
    private boolean field_198125_l;
    private boolean field_198126_m;
    private int field_198127_n;
    private int field_198128_o;
    private int field_198129_p;
    private int field_198130_q;
    private int field_198131_r;
    private int field_198132_s;
    private int field_198133_t;
    private int field_198134_u;
    private double field_198135_v;
    private String field_198136_w = "";
    private boolean field_198138_y;
    private int field_216532_z;
    private boolean field_216530_A;

    public MainWindow(IWindowEventListener p_i51170_1_, MonitorHandler p_i51170_2_, ScreenSize p_i51170_3_, @Nullable String videoModeName, String titleIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        this.field_216531_d = p_i51170_2_;
        this.func_227803_u_();
        this.func_227799_a_("Pre startup");
        this.field_227797_c_ = p_i51170_1_;
        Optional<Object> optional = VideoMode.func_198061_a((String)videoModeName);
        this.field_198124_k = optional.isPresent() ? optional : (p_i51170_3_.field_216496_c.isPresent() && p_i51170_3_.field_216497_d.isPresent() ? Optional.of(new VideoMode(p_i51170_3_.field_216496_c.getAsInt(), p_i51170_3_.field_216497_d.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.field_198126_m = this.field_198125_l = p_i51170_3_.field_216498_e;
        Monitor monitor = p_i51170_2_.func_216512_a(GLFW.glfwGetPrimaryMonitor());
        this.field_198129_p = p_i51170_3_.field_216494_a > 0 ? p_i51170_3_.field_216494_a : 1;
        this.field_198122_i = this.field_198129_p;
        this.field_198130_q = p_i51170_3_.field_216495_b > 0 ? p_i51170_3_.field_216495_b : 1;
        this.field_198123_j = this.field_198130_q;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)0);
        this.field_198119_f = EarlyProgressVisualization.INSTANCE.handOffWindow(() -> this.field_198129_p, () -> this.field_198130_q, () -> titleIn, () -> this.field_198125_l && monitor != null ? monitor.func_197995_f() : 0L);
        if (monitor != null) {
            VideoMode videomode = monitor.func_197992_a(this.field_198125_l ? this.field_198124_k : Optional.empty());
            this.field_198120_g = this.field_198127_n = monitor.func_197989_c() + videomode.func_198064_a() / 2 - this.field_198129_p / 2;
            this.field_198121_h = this.field_198128_o = monitor.func_197990_d() + videomode.func_198065_b() / 2 - this.field_198130_q / 2;
        } else {
            int[] aint1 = new int[1];
            int[] aint = new int[1];
            GLFW.glfwGetWindowPos((long)this.field_198119_f, (int[])aint1, (int[])aint);
            this.field_198120_g = this.field_198127_n = aint1[0];
            this.field_198121_h = this.field_198128_o = aint[0];
        }
        GLFW.glfwMakeContextCurrent((long)this.field_198119_f);
        GL.createCapabilities();
        this.func_198108_y();
        this.func_198103_w();
        GLFW.glfwSetFramebufferSizeCallback((long)this.field_198119_f, this::func_198102_b);
        GLFW.glfwSetWindowPosCallback((long)this.field_198119_f, this::func_198080_a);
        GLFW.glfwSetWindowSizeCallback((long)this.field_198119_f, this::func_198089_c);
        GLFW.glfwSetWindowFocusCallback((long)this.field_198119_f, this::func_198095_a);
    }

    public int func_227798_a_() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GLX._getRefreshRate((MainWindow)this);
    }

    public boolean func_227800_b_() {
        return GLX._shouldClose((MainWindow)this);
    }

    public static void func_211162_a(BiConsumer<Integer, String> p_211162_0_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i != 0) {
                long j = pointerbuffer.get();
                String s = j == 0L ? "" : MemoryUtil.memUTF8((long)j);
                p_211162_0_.accept(i, s);
            }
        }
    }

    public void func_216529_a(InputStream p_216529_1_, InputStream p_216529_2_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            if (p_216529_1_ == null) {
                throw new FileNotFoundException("icons/icon_16x16.png");
            }
            if (p_216529_2_ == null) {
                throw new FileNotFoundException("icons/icon_32x32.png");
            }
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = this.func_198111_a(p_216529_1_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = this.func_198111_a(p_216529_2_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)this.field_198119_f, (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            field_198114_a.error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuffer func_198111_a(InputStream p_198111_1_, IntBuffer p_198111_2_, IntBuffer p_198111_3_, IntBuffer p_198111_4_) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.func_225684_a_((InputStream)p_198111_1_);
            ((Buffer)bytebuffer).rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_198111_2_, (IntBuffer)p_198111_3_, (IntBuffer)p_198111_4_, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public void func_227799_a_(String renderPhaseIn) {
        this.field_198136_w = renderPhaseIn;
    }

    private void func_227803_u_() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFW.glfwSetErrorCallback(MainWindow::func_208034_b);
    }

    private static void func_208034_b(int error, long description) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        String s = "GLFW error " + error + ": " + MemoryUtil.memUTF8((long)description);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(s + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new GlException(s);
    }

    public void func_198084_a(int error, long description) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        String s = MemoryUtil.memUTF8((long)description);
        field_198114_a.error("########## GL ERROR ##########");
        field_198114_a.error("@ {}", (Object)this.field_198136_w);
        field_198114_a.error("{}: {}", (Object)error, (Object)s);
    }

    public void func_227801_c_() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.field_198115_b);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public void func_216523_b(boolean vsyncEnabled) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_216530_A = vsyncEnabled;
        GLFW.glfwSwapInterval((int)(vsyncEnabled ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        Callbacks.glfwFreeCallbacks((long)this.field_198119_f);
        this.field_198115_b.close();
        GLFW.glfwDestroyWindow((long)this.field_198119_f);
        GLFW.glfwTerminate();
    }

    private void func_198080_a(long windowPointer, int windowXIn, int windowYIn) {
        this.field_198127_n = windowXIn;
        this.field_198128_o = windowYIn;
    }

    private void func_198102_b(long windowPointer, int framebufferWidth, int framebufferHeight) {
        if (windowPointer == this.field_198119_f) {
            int i = this.func_198109_k();
            int j = this.func_198091_l();
            if (framebufferWidth != 0 && framebufferHeight != 0) {
                this.field_198131_r = framebufferWidth;
                this.field_198132_s = framebufferHeight;
                if (this.func_198109_k() != i || this.func_198091_l() != j) {
                    this.field_227797_c_.func_213226_a();
                }
            }
        }
    }

    private void func_198103_w() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.field_198119_f, (int[])aint, (int[])aint1);
        this.field_198131_r = aint[0];
        this.field_198132_s = aint1[0];
    }

    private void func_198089_c(long windowPointer, int windowWidthIn, int windowHeightIn) {
        this.field_198129_p = windowWidthIn;
        this.field_198130_q = windowHeightIn;
    }

    private void func_198095_a(long windowPointer, boolean hasFocus) {
        if (windowPointer == this.field_198119_f) {
            this.field_227797_c_.func_213228_a(hasFocus);
        }
    }

    public void func_216526_a(int p_216526_1_) {
        this.field_216532_z = p_216526_1_;
    }

    public int func_198082_x() {
        return this.field_216532_z;
    }

    public void func_227802_e_() {
        RenderSystem.flipFrame((long)this.field_198119_f);
        if (this.field_198125_l != this.field_198126_m) {
            this.field_198126_m = this.field_198125_l;
            this.func_216527_d(this.field_216530_A);
        }
    }

    public Optional<VideoMode> func_198106_d() {
        return this.field_198124_k;
    }

    public void func_224797_a(Optional<VideoMode> fullscreenModeIn) {
        boolean flag = !fullscreenModeIn.equals(this.field_198124_k);
        this.field_198124_k = fullscreenModeIn;
        if (flag) {
            this.field_198138_y = true;
        }
    }

    public void func_198097_f() {
        if (this.field_198125_l && this.field_198138_y) {
            this.field_198138_y = false;
            this.func_198108_y();
            this.field_227797_c_.func_213226_a();
        }
    }

    private void func_198108_y() {
        boolean flag;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.field_198119_f) != 0L;
        if (this.field_198125_l) {
            Monitor monitor = this.field_216531_d.func_216515_a(this);
            if (monitor == null) {
                field_198114_a.warn("Failed to find suitable monitor for fullscreen mode");
                this.field_198125_l = false;
            } else {
                VideoMode videomode = monitor.func_197992_a(this.field_198124_k);
                if (!flag) {
                    this.field_198120_g = this.field_198127_n;
                    this.field_198121_h = this.field_198128_o;
                    this.field_198122_i = this.field_198129_p;
                    this.field_198123_j = this.field_198130_q;
                }
                this.field_198127_n = 0;
                this.field_198128_o = 0;
                this.field_198129_p = videomode.func_198064_a();
                this.field_198130_q = videomode.func_198065_b();
                GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)monitor.func_197995_f(), (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)videomode.func_198067_f());
            }
        } else {
            this.field_198127_n = this.field_198120_g;
            this.field_198128_o = this.field_198121_h;
            this.field_198129_p = this.field_198122_i;
            this.field_198130_q = this.field_198123_j;
            GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)0L, (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)-1);
        }
    }

    public void func_198077_g() {
        this.field_198125_l = !this.field_198125_l;
    }

    private void func_216527_d(boolean vsyncEnabled) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        try {
            this.func_198108_y();
            this.field_227797_c_.func_213226_a();
            this.func_216523_b(vsyncEnabled);
            this.func_227802_e_();
        }
        catch (Exception exception) {
            field_198114_a.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int func_216521_a(int guiScaleIn, boolean forceUnicode) {
        int i;
        for (i = 1; i != guiScaleIn && i < this.field_198131_r && i < this.field_198132_s && this.field_198131_r / (i + 1) >= 320 && this.field_198132_s / (i + 1) >= 240; ++i) {
        }
        if (forceUnicode && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void func_216525_a(double scaleFactor) {
        this.field_198135_v = scaleFactor;
        int i = (int)((double)this.field_198131_r / scaleFactor);
        this.field_198133_t = (double)this.field_198131_r / scaleFactor > (double)i ? i + 1 : i;
        int j = (int)((double)this.field_198132_s / scaleFactor);
        this.field_198134_u = (double)this.field_198132_s / scaleFactor > (double)j ? j + 1 : j;
    }

    public void func_230148_b_(String p_230148_1_) {
        GLFW.glfwSetWindowTitle((long)this.field_198119_f, (CharSequence)p_230148_1_);
    }

    public long func_198092_i() {
        return this.field_198119_f;
    }

    public boolean func_198113_j() {
        return this.field_198125_l;
    }

    public int func_198109_k() {
        return this.field_198131_r;
    }

    public int func_198091_l() {
        return this.field_198132_s;
    }

    public int func_198105_m() {
        return this.field_198129_p;
    }

    public int func_198083_n() {
        return this.field_198130_q;
    }

    public int func_198107_o() {
        return this.field_198133_t;
    }

    public int func_198087_p() {
        return this.field_198134_u;
    }

    public int func_198099_q() {
        return this.field_198127_n;
    }

    public int func_198079_r() {
        return this.field_198128_o;
    }

    public double func_198100_s() {
        return this.field_198135_v;
    }

    @Nullable
    public Monitor func_224796_s() {
        return this.field_216531_d.func_216515_a(this);
    }

    public void func_224798_d(boolean valueIn) {
        InputMappings.func_224791_a((long)this.field_198119_f, (boolean)valueIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GlException
    extends UndeclaredException {
        private GlException(String messageIn) {
            super(messageIn);
        }
    }
}

