/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChestTileEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final ModelRenderer field_228862_a_;
    private final ModelRenderer field_228863_c_;
    private final ModelRenderer field_228864_d_;
    private final ModelRenderer field_228865_e_;
    private final ModelRenderer field_228866_f_;
    private final ModelRenderer field_228867_g_;
    private final ModelRenderer field_228868_h_;
    private final ModelRenderer field_228869_i_;
    private final ModelRenderer field_228870_j_;
    private boolean field_147509_j;

    public ChestTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.field_147509_j = true;
        }
        this.field_228863_c_ = new ModelRenderer(64, 64, 0, 19);
        this.field_228863_c_.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.field_228862_a_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228862_a_.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.field_228862_a_.field_78797_d = 9.0f;
        this.field_228862_a_.field_78798_e = 1.0f;
        this.field_228864_d_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228864_d_.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.field_228864_d_.field_78797_d = 8.0f;
        this.field_228866_f_ = new ModelRenderer(64, 64, 0, 19);
        this.field_228866_f_.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.field_228865_e_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228865_e_.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.field_228865_e_.field_78797_d = 9.0f;
        this.field_228865_e_.field_78798_e = 1.0f;
        this.field_228867_g_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228867_g_.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.field_228867_g_.field_78797_d = 8.0f;
        this.field_228869_i_ = new ModelRenderer(64, 64, 0, 19);
        this.field_228869_i_.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.field_228868_h_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228868_h_.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.field_228868_h_.field_78797_d = 9.0f;
        this.field_228868_h_.field_78798_e = 1.0f;
        this.field_228870_j_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228870_j_.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.field_228870_j_.field_78797_d = 8.0f;
    }

    public void func_225616_a_(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = ((TileEntity)((Object)tileEntityIn)).func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? ((TileEntity)((Object)tileEntityIn)).func_195044_w() : (BlockState)((Object)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)((Object)Direction.SOUTH)));
        ChestType chesttype = blockstate.func_196959_b((IProperty)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((IProperty)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)((Object)blockstate.func_177229_b((IProperty)ChestBlock.field_176459_a))).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = flag ? abstractchestblock.func_225536_a_(blockstate, world, ((TileEntity)((Object)tileEntityIn)).func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_((IChestLid)((IChestLid)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            Material material = this.getMaterial(tileEntityIn, chesttype);
            IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, RenderType::func_228638_b_);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228868_h_, this.field_228870_j_, this.field_228869_i_, f1, i, combinedOverlayIn);
                } else {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228865_e_, this.field_228867_g_, this.field_228866_f_, f1, i, combinedOverlayIn);
                }
            } else {
                this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228862_a_, this.field_228864_d_, this.field_228863_c_, f1, i, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void func_228871_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    protected Material getMaterial(T tileEntity, ChestType chestType) {
        return Atlases.func_228771_a_(tileEntity, (ChestType)chestType, (boolean)this.field_147509_j);
    }
}

