/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockStateParser {
    public static final SimpleCommandExceptionType field_199831_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.tag.disallowed", new Object[0]));
    public static final DynamicCommandExceptionType field_197259_a = new DynamicCommandExceptionType(p_208687_0_ -> new TranslationTextComponent("argument.block.id.invalid", p_208687_0_));
    public static final Dynamic2CommandExceptionType field_197260_b = new Dynamic2CommandExceptionType((p_208685_0_, p_208685_1_) -> new TranslationTextComponent("argument.block.property.unknown", p_208685_0_, p_208685_1_));
    public static final Dynamic2CommandExceptionType field_197261_c = new Dynamic2CommandExceptionType((p_208690_0_, p_208690_1_) -> new TranslationTextComponent("argument.block.property.duplicate", p_208690_1_, p_208690_0_));
    public static final Dynamic3CommandExceptionType field_197262_d = new Dynamic3CommandExceptionType((p_208684_0_, p_208684_1_, p_208684_2_) -> new TranslationTextComponent("argument.block.property.invalid", p_208684_0_, p_208684_2_, p_208684_1_));
    public static final Dynamic2CommandExceptionType field_197263_e = new Dynamic2CommandExceptionType((p_208689_0_, p_208689_1_) -> new TranslationTextComponent("argument.block.property.novalue", p_208689_0_, p_208689_1_));
    public static final SimpleCommandExceptionType field_197264_f = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.property.unclosed", new Object[0]));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> field_197265_g = SuggestionsBuilder::buildFuture;
    private final StringReader field_197266_h;
    private final boolean field_199832_j;
    private final Map<IProperty<?>, Comparable<?>> field_197267_i = Maps.newHashMap();
    private final Map<String, String> field_200141_l = Maps.newHashMap();
    private ResourceLocation field_197268_j = new ResourceLocation("");
    private StateContainer<Block, BlockState> field_197269_k;
    private BlockState field_197270_l;
    @Nullable
    private CompoundNBT field_197271_m;
    private ResourceLocation field_199833_p = new ResourceLocation("");
    private int field_201954_r;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> field_197272_n = field_197265_g;

    public BlockStateParser(StringReader readerIn, boolean allowTags) {
        this.field_197266_h = readerIn;
        this.field_199832_j = allowTags;
    }

    public Map<IProperty<?>, Comparable<?>> func_197254_a() {
        return this.field_197267_i;
    }

    @Nullable
    public BlockState func_197249_b() {
        return this.field_197270_l;
    }

    @Nullable
    public CompoundNBT func_197241_c() {
        return this.field_197271_m;
    }

    @Nullable
    public ResourceLocation func_199829_d() {
        return this.field_199833_p;
    }

    public BlockStateParser func_197243_a(boolean parseTileEntity) throws CommandSyntaxException {
        this.field_197272_n = this::func_197250_h;
        if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '#') {
            this.func_199827_f();
            this.field_197272_n = this::func_212599_i;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_200137_h();
                this.field_197272_n = this::func_197244_d;
            }
        } else {
            this.func_197258_d();
            this.field_197272_n = this::func_197255_g;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_197257_e();
                this.field_197272_n = this::func_197244_d;
            }
        }
        if (parseTileEntity && this.field_197266_h.canRead() && this.field_197266_h.peek() == '{') {
            this.field_197272_n = field_197265_g;
            this.func_197240_f();
        }
        return this;
    }

    private CompletableFuture<Suggestions> func_197252_b(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.func_197256_c(builder);
    }

    private CompletableFuture<Suggestions> func_200136_c(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.func_200134_e(builder);
    }

    private CompletableFuture<Suggestions> func_197256_c(SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (IProperty iproperty : this.field_197270_l.func_206869_a()) {
            if (this.field_197267_i.containsKey(iproperty) || !iproperty.func_177701_a().startsWith(s)) continue;
            builder.suggest(iproperty.func_177701_a() + '=');
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_200134_e(SuggestionsBuilder builder) {
        Tag<Block> tag;
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (tag = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            for (Block block : tag.func_199885_a()) {
                for (IProperty iproperty : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(iproperty.func_177701_a()) || !iproperty.func_177701_a().startsWith(s)) continue;
                    builder.suggest(iproperty.func_177701_a() + '=');
                }
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197244_d(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty() && this.func_212598_k()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private boolean func_212598_k() {
        Tag<Block> tag;
        if (this.field_197270_l != null) {
            return this.field_197270_l.hasTileEntity();
        }
        if (this.field_199833_p != null && (tag = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            for (Block block : tag.func_199885_a()) {
                if (!block.func_176223_P().hasTileEntity()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> func_197246_e(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('='));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197248_f(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        if (builder.getRemaining().isEmpty() && this.field_197267_i.size() < this.field_197270_l.func_206869_a().size()) {
            builder.suggest(String.valueOf(','));
        }
        return builder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder func_201037_a(SuggestionsBuilder builder, IProperty<T> property) {
        for (Comparable t : property.func_177700_c()) {
            if (t instanceof Integer) {
                builder.suggest(((Integer)t).intValue());
                continue;
            }
            builder.suggest(property.func_177702_a(t));
        }
        return builder;
    }

    private CompletableFuture<Suggestions> func_200140_a(SuggestionsBuilder builder, String property) {
        Tag<Block> tag;
        boolean flag = false;
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (tag = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            block0: for (Block block : tag.func_199885_a()) {
                IProperty iproperty = block.func_176194_O().func_185920_a(property);
                if (iproperty != null) {
                    BlockStateParser.func_201037_a(builder, iproperty);
                }
                if (flag) continue;
                for (IProperty iproperty1 : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(iproperty1.func_177701_a())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            builder.suggest(String.valueOf(','));
        }
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_212599_i(SuggestionsBuilder p_212599_1_) {
        Tag<Block> tag;
        if (p_212599_1_.getRemaining().isEmpty() && (tag = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator<Block> iterator = tag.func_199885_a().iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = iterator.next()).func_176194_O().func_177623_d().isEmpty()) && (flag1 |= block.func_149716_u()))) {
            }
            if (flag) {
                p_212599_1_.suggest(String.valueOf('['));
            }
            if (flag1) {
                p_212599_1_.suggest(String.valueOf('{'));
            }
        }
        return this.func_201953_j(p_212599_1_);
    }

    private CompletableFuture<Suggestions> func_197255_g(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            if (!this.field_197270_l.func_177230_c().func_176194_O().func_177623_d().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            if (this.field_197270_l.hasTileEntity()) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201953_j(SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(BlockTags.func_199896_a().func_199908_a(), (SuggestionsBuilder)builder.createOffset(this.field_201954_r).add(builder));
    }

    private CompletableFuture<Suggestions> func_197250_h(SuggestionsBuilder builder) {
        if (this.field_199832_j) {
            ISuggestionProvider.func_197006_a(BlockTags.func_199896_a().func_199908_a(), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
        }
        ISuggestionProvider.func_197014_a((Iterable)Registry.field_212618_g.func_148742_b(), (SuggestionsBuilder)builder);
        return builder.buildFuture();
    }

    public void func_197258_d() throws CommandSyntaxException {
        int i = this.field_197266_h.getCursor();
        this.field_197268_j = ResourceLocation.func_195826_a((StringReader)this.field_197266_h);
        Block block = (Block)((Object)Registry.field_212618_g.func_218349_b(this.field_197268_j).orElseThrow(() -> {
            this.field_197266_h.setCursor(i);
            return field_197259_a.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString());
        }));
        this.field_197269_k = block.func_176194_O();
        this.field_197270_l = block.func_176223_P();
    }

    public void func_199827_f() throws CommandSyntaxException {
        if (!this.field_199832_j) {
            throw field_199831_a.create();
        }
        this.field_197272_n = this::func_201953_j;
        this.field_197266_h.expect('#');
        this.field_201954_r = this.field_197266_h.getCursor();
        this.field_199833_p = ResourceLocation.func_195826_a((StringReader)this.field_197266_h);
    }

    public void func_197257_e() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_197252_b;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int i = this.field_197266_h.getCursor();
            String s = this.field_197266_h.readString();
            IProperty iproperty = this.field_197269_k.func_185920_a(s);
            if (iproperty == null) {
                this.field_197266_h.setCursor(i);
                throw field_197260_b.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            if (this.field_197267_i.containsKey(iproperty)) {
                this.field_197266_h.setCursor(i);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = this::func_197246_e;
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = p_197251_1_ -> BlockStateParser.func_201037_a(p_197251_1_, iproperty).buildFuture();
            int j = this.field_197266_h.getCursor();
            this.func_197253_a(iproperty, this.field_197266_h.readString(), j);
            this.field_197272_n = this::func_197248_f;
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_197256_c;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (this.field_197266_h.canRead()) {
            this.field_197266_h.skip();
            return;
        }
        throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
    }

    public void func_200137_h() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_200136_c;
        int i = -1;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int j = this.field_197266_h.getCursor();
            String s = this.field_197266_h.readString();
            if (this.field_200141_l.containsKey(s)) {
                this.field_197266_h.setCursor(j);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                this.field_197266_h.setCursor(j);
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = p_200138_2_ -> this.func_200140_a((SuggestionsBuilder)p_200138_2_, s);
            i = this.field_197266_h.getCursor();
            String s1 = this.field_197266_h.readString();
            this.field_200141_l.put(s, s1);
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            i = -1;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_200134_e;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (this.field_197266_h.canRead()) {
            this.field_197266_h.skip();
            return;
        }
        if (i >= 0) {
            this.field_197266_h.setCursor(i);
        }
        throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
    }

    public void func_197240_f() throws CommandSyntaxException {
        this.field_197271_m = new JsonToNBT(this.field_197266_h).func_193593_f();
    }

    private <T extends Comparable<T>> void func_197253_a(IProperty<T> property, String value, int valuePosition) throws CommandSyntaxException {
        Optional optional = property.func_185929_b(value);
        if (!optional.isPresent()) {
            this.field_197266_h.setCursor(valuePosition);
            throw field_197262_d.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)property.func_177701_a(), (Object)value);
        }
        this.field_197270_l = (BlockState)((Object)this.field_197270_l.func_206870_a(property, (Comparable)optional.get()));
        this.field_197267_i.put(property, (Comparable<?>)optional.get());
    }

    public static String func_197247_a(BlockState state) {
        StringBuilder stringbuilder = new StringBuilder(Registry.field_212618_g.func_177774_c((Object)state.func_177230_c()).toString());
        if (!state.func_206869_a().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry entry : state.func_206871_b().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                BlockStateParser.func_211375_a(stringbuilder, (IProperty)entry.getKey(), (Comparable)entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void func_211375_a(StringBuilder builder, IProperty<T> property, Comparable<?> value) {
        builder.append(property.func_177701_a());
        builder.append('=');
        builder.append(property.func_177702_a(value));
    }

    public CompletableFuture<Suggestions> func_197245_a(SuggestionsBuilder builder) {
        return this.field_197272_n.apply(builder.createOffset(this.field_197266_h.getCursor()));
    }

    public Map<String, String> func_200139_j() {
        return this.field_200141_l;
    }
}

