/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.TieredItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class HoeItem
extends TieredItem {
    private final float field_185072_b;
    protected static final Map<Block, BlockState> field_195973_b = Maps.newHashMap((Map)ImmutableMap.of((Object)((Object)Blocks.field_196658_i), (Object)((Object)Blocks.field_150458_ak.func_176223_P()), (Object)((Object)Blocks.field_185774_da), (Object)((Object)Blocks.field_150458_ak.func_176223_P()), (Object)((Object)Blocks.field_150346_d), (Object)((Object)Blocks.field_150458_ak.func_176223_P()), (Object)((Object)Blocks.field_196660_k), (Object)((Object)Blocks.field_150346_d.func_176223_P())));

    public HoeItem(IItemTier tier, float attackSpeedIn, Item.Properties builder) {
        super(tier, builder);
        this.field_185072_b = attackSpeedIn;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = field_195973_b.get((Object)world.func_180495_p(blockpos).func_177230_c())) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, playerentity, p_220043_1_ -> p_220043_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220042_0_ -> p_220042_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.field_185072_b, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

