/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegion
implements IWorld {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final List<IChunk> field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_217380_e;
    private final ServerWorld field_201689_f;
    private final long field_201690_g;
    private final int field_201691_h;
    private final WorldInfo field_201692_i;
    private final Random field_201693_j;
    private final Dimension field_201694_k;
    private final GenerationSettings field_201695_l;
    private final ITickList<Block> field_205336_m = new WorldGenTickList(p_205335_1_ -> this.func_217349_x((BlockPos)p_205335_1_).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList(p_205334_1_ -> this.func_217349_x((BlockPos)p_205334_1_).func_212247_j());
    private final BiomeManager field_229862_o_;

    public WorldGenRegion(ServerWorld p_i50698_1_, List<IChunk> p_i50698_2_) {
        int i = MathHelper.func_76128_c((double)Math.sqrt(p_i50698_2_.size()));
        if (i * i != p_i50698_2_.size()) {
            throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Cache size is not a square."));
        }
        ChunkPos chunkpos = p_i50698_2_.get(p_i50698_2_.size() / 2).func_76632_l();
        this.field_201684_a = p_i50698_2_;
        this.field_201685_b = chunkpos.field_77276_a;
        this.field_201686_c = chunkpos.field_77275_b;
        this.field_217380_e = i;
        this.field_201689_f = p_i50698_1_;
        this.field_201690_g = p_i50698_1_.func_72905_C();
        this.field_201695_l = p_i50698_1_.func_72863_F().func_201711_g().func_201496_a_();
        this.field_201691_h = p_i50698_1_.func_181545_F();
        this.field_201692_i = p_i50698_1_.func_72912_H();
        this.field_201693_j = p_i50698_1_.func_201674_k();
        this.field_201694_k = p_i50698_1_.func_201675_m();
        this.field_229862_o_ = new BiomeManager((BiomeManager.IBiomeReader)this, WorldInfo.func_227498_c_(this.field_201690_g), this.field_201694_k.func_186058_p().func_227176_e_());
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    @Override
    public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.func_217348_a(chunkX, chunkZ, ChunkStatus.field_223226_a_);
    }

    @Override
    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        IChunk ichunk;
        if (this.func_217354_b(x, z)) {
            ChunkPos chunkpos = this.field_201684_a.get(0).func_76632_l();
            int i = x - chunkpos.field_77276_a;
            int j = z - chunkpos.field_77275_b;
            ichunk = this.field_201684_a.get(i + j * this.field_217380_e);
            if (ichunk.func_201589_g().func_209003_a(requiredStatus)) {
                return ichunk;
            }
        } else {
            ichunk = null;
        }
        if (!nonnull) {
            return null;
        }
        IChunk ichunk1 = this.field_201684_a.get(0);
        IChunk ichunk2 = this.field_201684_a.get(this.field_201684_a.size() - 1);
        field_208303_a.error("Requested chunk : {} {}", (Object)x, (Object)z);
        field_208303_a.error("Region bounds : {} {} | {} {}", (Object)ichunk1.func_76632_l().field_77276_a, (Object)ichunk1.func_76632_l().field_77275_b, (Object)ichunk2.func_76632_l().field_77276_a, (Object)ichunk2.func_76632_l().field_77275_b);
        if (ichunk != null) {
            throw (RuntimeException)Util.func_229757_c_((Throwable)new RuntimeException(String.format("Chunk is not of correct status. Expecting %s, got %s | %s %s", new Object[]{requiredStatus, ichunk.func_201589_g(), x, z})));
        }
        throw (RuntimeException)Util.func_229757_c_((Throwable)new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", x, z)));
    }

    @Override
    public boolean func_217354_b(int chunkX, int chunkZ) {
        IChunk ichunk = this.field_201684_a.get(0);
        IChunk ichunk1 = this.field_201684_a.get(this.field_201684_a.size() - 1);
        return chunkX >= ichunk.func_76632_l().field_77276_a && chunkX <= ichunk1.func_76632_l().field_77276_a && chunkZ >= ichunk.func_76632_l().field_77275_b && chunkZ <= ichunk1.func_76632_l().field_77275_b;
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.func_217349_x(pos).func_204610_c(pos);
    }

    @Nullable
    public PlayerEntity func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int func_175657_ab() {
        return 0;
    }

    @Override
    public BiomeManager func_225523_d_() {
        return this.field_229862_o_;
    }

    @Override
    public Biome func_225604_a_(int x, int y, int z) {
        return this.field_201689_f.func_225604_a_(x, y, z);
    }

    public WorldLightManager func_225524_e_() {
        return this.field_201689_f.func_225524_e_();
    }

    public boolean func_225521_a_(BlockPos p_225521_1_, boolean p_225521_2_, @Nullable Entity p_225521_3_) {
        BlockState blockstate = this.func_180495_p(p_225521_1_);
        if (blockstate.isAir((IBlockReader)((Object)this), p_225521_1_)) {
            return false;
        }
        if (p_225521_2_) {
            TileEntity tileentity = blockstate.hasTileEntity() ? this.func_175625_s(p_225521_1_) : null;
            Block.func_220054_a(blockstate, this.field_201689_f, p_225521_1_, tileentity, p_225521_3_, ItemStack.field_190927_a);
        }
        return this.func_180501_a(p_225521_1_, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IChunk ichunk = this.func_217349_x(pos);
        TileEntity tileentity = ichunk.func_175625_s(pos);
        if (tileentity != null) {
            return tileentity;
        }
        CompoundNBT compoundnbt = ichunk.func_201579_g(pos);
        if (compoundnbt != null) {
            if ("DUMMY".equals(compoundnbt.func_74779_i("id"))) {
                BlockState state = this.func_180495_p(pos);
                if (!state.hasTileEntity()) {
                    return null;
                }
                tileentity = state.createTileEntity((IBlockReader)((Object)this.field_201689_f));
            } else {
                tileentity = TileEntity.func_203403_c(compoundnbt);
            }
            if (tileentity != null) {
                ichunk.func_177426_a(pos, tileentity);
                return tileentity;
            }
        }
        if (ichunk.func_180495_p(pos).hasTileEntity()) {
            field_208303_a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        IChunk ichunk = this.func_217349_x(pos);
        BlockState blockstate = ichunk.func_177436_a(pos, newState, false);
        if (blockstate != null) {
            this.field_201689_f.func_217393_a(pos, blockstate, newState);
        }
        Block block = newState.func_177230_c();
        if (newState.hasTileEntity()) {
            if (ichunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                ichunk.func_177426_a(pos, newState.createTileEntity((IBlockReader)((Object)this)));
            } else {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74768_a("x", pos.func_177958_n());
                compoundnbt.func_74768_a("y", pos.func_177956_o());
                compoundnbt.func_74768_a("z", pos.func_177952_p());
                compoundnbt.func_74778_a("id", "DUMMY");
                ichunk.func_201591_a(compoundnbt);
            }
        } else if (blockstate != null && blockstate.hasTileEntity()) {
            ichunk.func_177425_e(pos);
        }
        if (newState.func_202065_c((IBlockReader)((Object)this), pos)) {
            this.func_201683_l(pos);
        }
        return true;
    }

    private void func_201683_l(BlockPos pos) {
        this.func_217349_x(pos).func_201594_d(pos);
    }

    public boolean func_217376_c(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
        this.func_212866_a_(i, j).func_76612_a(entityIn);
        return true;
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        return this.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    @Override
    public boolean func_201670_d() {
        return false;
    }

    @Override
    @Deprecated
    public ServerWorld func_201672_e() {
        return this.field_201689_f;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos pos) {
        if (!this.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_130001_d());
    }

    @Override
    public AbstractChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    @Override
    public long func_72905_C() {
        return this.field_201690_g;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    @Override
    public int func_181545_F() {
        return this.field_201691_h;
    }

    @Override
    public Random func_201674_k() {
        return this.field_201693_j;
    }

    @Override
    public void func_195592_c(BlockPos pos, Block blockIn) {
    }

    @Override
    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.func_212866_a_(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1;
    }

    @Override
    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_175694_M() {
        return this.field_201689_f.func_175694_M();
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_201694_k;
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return Collections.emptyList();
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }
}

