/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import java.util.Collections;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiIndustrialTurbine
extends GuiMekanismTile<TileEntityTurbineCasing, MekanismTileContainer<TileEntityTurbineCasing>> {
    public GuiIndustrialTurbine(MekanismTileContainer<TileEntityTurbineCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    public void init() {
        super.init();
        this.addButton((Widget)new GuiInnerScreen((IGuiWrapper)this, 50, 23, 112, 41));
        this.addButton((Widget)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.STAT));
        this.addButton((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure == null) {
                    return EnergyDisplay.ZERO.getTextComponent();
                }
                return EnergyDisplay.of((FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).energyContainer.getEnergy(), (FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).energyContainer.getMaxEnergy()).getTextComponent();
            }

            public double getLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure == null) {
                    return 1.0;
                }
                return ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).energyContainer.getEnergy().divideToLevel(((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).energyContainer.getMaxEnergy());
            }
        }, 164, 16));
        this.addButton((Widget)new GuiVerticalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return GeneratorsLang.TURBINE_STEAM_INPUT_RATE.translate(new Object[]{((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure == null ? 0L : ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).lastSteamInput});
            }

            public double getLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure == null) {
                    return 0.0;
                }
                double rate = Math.min((double)(((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).lowerVolume * ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get(), (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                if (rate == 0.0) {
                    return 0.0;
                }
                return (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).structure).lastSteamInput / rate;
            }
        }, 40, 13));
        this.addButton((Widget)new GuiGasGauge(() -> ((TileEntityTurbineCasing)this.tile).structure == null ? null : ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).gasTank, () -> ((TileEntityTurbineCasing)this.tile).structure == null ? Collections.emptyList() : ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).getGasTanks(null), GaugeType.MEDIUM, (IGuiWrapper)this, 6, 13));
        this.addButton((Widget)new GuiEnergyInfo(() -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            if (((TileEntityTurbineCasing)this.tile).structure == null) {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            } else {
                storing = EnergyDisplay.of((FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).energyContainer.getEnergy(), (FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).energyContainer.getMaxEnergy());
                producing = EnergyDisplay.of((FloatingLong)((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientFlow * (long)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get())));
            }
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }, (IGuiWrapper)this));
        this.addButton((Widget)new GuiGasMode((IGuiWrapper)this, this.getGuiLeft() + 159, this.getGuiTop() + 72, true, () -> ((TileEntityTurbineCasing)this.tile).structure == null ? TileEntityGasTank.GasMode.IDLE : ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).dumpMode, ((TileEntityTurbineCasing)this.tile).func_174877_v(), 0));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 4, 0x404040);
        this.drawString(((TileEntityTurbineCasing)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityTurbineCasing)this.tile).getName()) / 2, 5, 0x404040);
        if (((TileEntityTurbineCasing)this.tile).structure != null) {
            FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
            double rate = (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).lowerVolume * ((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientDispersers * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
            rate = Math.min(rate, (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
            this.renderScaledText((ITextComponent)GeneratorsLang.TURBINE_PRODUCTION_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)energyMultiplier.multiply(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientFlow))}), 53, 26, 52480, 106);
            this.renderScaledText((ITextComponent)GeneratorsLang.TURBINE_FLOW_RATE.translate(new Object[]{((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientFlow}), 53, 35, 52480, 106);
            this.renderScaledText((ITextComponent)GeneratorsLang.TURBINE_CAPACITY.translate(new Object[]{((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).getSteamCapacity()}), 53, 44, 52480, 106);
            this.renderScaledText((ITextComponent)GeneratorsLang.TURBINE_MAX_FLOW.translate(new Object[]{rate}), 53, 53, 52480, 106);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

