/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.network.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiReactorFuel
extends GuiReactorInfo {
    private TextFieldWidget injectionRateField;

    public GuiReactorFuel(EmptyTileContainer<TileEntityReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton((Widget)new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tile).isFormed() ? Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getEnergy(), (FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getMaxEnergy())}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).getReactor().getPassiveGeneration(false, true))})) : Collections.emptyList(), (IGuiWrapper)this));
        this.addButton((Widget)new GuiGasGauge(() -> ((TileEntityReactorController)this.tile).deuteriumTank, () -> ((TileEntityReactorController)this.tile).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 25, 64));
        this.addButton((Widget)new GuiGasGauge(() -> ((TileEntityReactorController)this.tile).fuelTank, () -> ((TileEntityReactorController)this.tile).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 79, 50));
        this.addButton((Widget)new GuiGasGauge(() -> ((TileEntityReactorController)this.tile).tritiumTank, () -> ((TileEntityReactorController)this.tile).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 133, 64));
        this.addButton((Widget)new GuiProgress(() -> ((TileEntityReactorController)this.tile).isBurning() ? 1.0 : 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 47, 76));
        this.addButton((Widget)new GuiProgress(() -> ((TileEntityReactorController)this.tile).isBurning() ? 1.0 : 0.0, ProgressType.SMALL_LEFT, (IGuiWrapper)this, 101, 76));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.HEAT));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.STAT));
        this.injectionRateField = new TextFieldWidget(this.font, this.getGuiLeft() + 98, this.getGuiTop() + 115, 26, 11, "");
        this.addButton((Widget)this.injectionRateField);
        this.injectionRateField.changeFocus(true);
        this.injectionRateField.func_146203_f(2);
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.injectionRateField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.injectionRateField.func_146180_a(s);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawString(((TileEntityReactorController)this.tile).getName(), 46, 6, 0x404040);
        this.drawCenteredText((ITextComponent)GeneratorsLang.REACTOR_INJECTION_RATE.translate(new Object[]{((TileEntityReactorController)this.tile).getReactor() == null ? MekanismLang.NONE : Integer.valueOf(((TileEntityReactorController)this.tile).getReactor().getInjectionRate())}), 0, this.getXSize(), 35, 0x404040);
        this.drawString((ITextComponent)GeneratorsLang.REACTOR_EDIT_RATE.translate(new Object[0]), 50, 117, 0x404040);
    }

    public void tick() {
        super.tick();
        this.injectionRateField.func_146178_a();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.injectionRateField.func_212955_f()) {
            if (keyCode == 256) {
                this.injectionRateField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.setInjection();
                return true;
            }
            return this.injectionRateField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.injectionRateField.func_212955_f()) {
            if (Character.isDigit(c)) {
                return this.injectionRateField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    private void setInjection() {
        if (!this.injectionRateField.func_146179_b().isEmpty()) {
            MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.INJECTION_RATE, (TileEntity)this.tile, Integer.parseInt(this.injectionRateField.func_146179_b())));
            this.injectionRateField.func_146180_a("");
        }
    }
}

