/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiReactorStats
extends GuiReactorInfo {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();

    public GuiReactorStats(EmptyTileContainer<TileEntityReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton((Widget)new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tile).isFormed() ? Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getEnergy(), (FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getMaxEnergy())}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).getReactor().getPassiveGeneration(false, true))})) : Collections.emptyList(), (IGuiWrapper)this));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.HEAT));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.FUEL));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityReactorController)this.tile).getName(), 46, 6, 0x404040);
        if (((TileEntityReactorController)this.tile).isFormed()) {
            this.drawString(GeneratorsLang.REACTOR_PASSIVE.translateColored(EnumColor.DARK_GREEN, new Object[0]), 6, 26, 0x404040);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{((TileEntityReactorController)this.tile).getReactor().getMinInjectionRate(false)}), 16, 36, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getIgnitionTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 46, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getMaxPlasmaTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 56, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getMaxCasingTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 66, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).getReactor().getPassiveGeneration(false, false))}), 16, 76, 0x404040, 156);
            this.drawString(GeneratorsLang.REACTOR_ACTIVE.translateColored(EnumColor.DARK_BLUE, new Object[0]), 6, 92, 0x404040);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{((TileEntityReactorController)this.tile).getReactor().getMinInjectionRate(true)}), 16, 102, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getIgnitionTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 112, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getMaxPlasmaTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 122, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityReactorController)this.tile).getReactor().getMaxCasingTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16, 132, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).getReactor().getPassiveGeneration(true, false))}), 16, 142, 0x404040, 156);
            this.renderScaledText((ITextComponent)GeneratorsLang.REACTOR_STEAM_PRODUCTION.translate(new Object[]{nf.format(((TileEntityReactorController)this.tile).getReactor().getSteamPerTick(false))}), 16, 152, 0x404040, 156);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

