/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
public class RenderWindGenerator
extends MekanismTileEntityRenderer<TileEntityWindGenerator>
implements IWireFrameRenderer {
    private final ModelWindGenerator model = new ModelWindGenerator();

    public RenderWindGenerator(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityWindGenerator tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        double angle = this.performTranslationsAndGetAngle(tile, partialTick, matrix);
        this.model.render(matrix, renderer, angle, light, overlayLight);
        matrix.func_227865_b_();
    }

    protected String getProfilerSection() {
        return "windGenerator";
    }

    public boolean isGlobalRenderer(TileEntityWindGenerator tile) {
        return true;
    }

    public void renderWireFrame(TileEntity tile, float partialTick, MatrixStack matrix, IVertexBuilder buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntityWindGenerator) {
            double angle = this.performTranslationsAndGetAngle((TileEntityWindGenerator)tile, partialTick, matrix);
            this.model.renderWireFrame(matrix, buffer, angle, red, green, blue, alpha);
            matrix.func_227865_b_();
        }
    }

    private double performTranslationsAndGetAngle(TileEntityWindGenerator tile, float partialTick, MatrixStack matrix) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate((MatrixStack)matrix, (Direction)tile.getDirection(), (float)0.0f, (float)180.0f, (float)90.0f, (float)270.0f);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        double angle = tile.getAngle();
        if (tile.getActive()) {
            angle = (tile.getAngle() + (double)(((float)tile.func_174877_v().func_177956_o() + 4.0f) / 8.0f * partialTick)) % 360.0;
        }
        return angle;
    }
}

