/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.chemical.MultiblockGasTank;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineGasTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;

public class SynchronizedTurbineData
extends SynchronizedData<SynchronizedTurbineData>
implements IMekanismGasHandler,
IMekanismStrictEnergyHandler {
    public static final float ROTATION_THRESHOLD = 0.001f;
    public static Object2FloatMap<UUID> clientRotationMap = new Object2FloatOpenHashMap();
    public final MultiblockGasTank<TileEntityTurbineCasing> gasTank;
    private final List<IGasTank> gasTanks;
    public IExtendedFluidTank ventTank;
    public List<IExtendedFluidTank> ventTanks;
    public IEnergyContainer energyContainer;
    public List<IEnergyContainer> energyContainers;
    public TileEntityGasTank.GasMode dumpMode = TileEntityGasTank.GasMode.IDLE;
    private FloatingLong energyCapacity = FloatingLong.ZERO;
    public int blades;
    public int vents;
    public int coils;
    public int condensers;
    public int lowerVolume;
    public Coord4D complex;
    public long lastSteamInput;
    public long newSteamInput;
    public int clientDispersers;
    public long clientFlow;
    public float clientRotation;

    public SynchronizedTurbineData(TileEntityTurbineCasing tile) {
        this.gasTank = new TurbineGasTank(tile);
        this.gasTanks = Collections.singletonList(this.gasTank);
        this.ventTank = VariableCapacityFluidTank.create(() -> tile.structure == null ? 1000 : ((SynchronizedTurbineData)tile.structure).condensers * MekanismGeneratorsConfig.generators.condenserRate.get(), (stack, automationType) -> automationType != AutomationType.EXTERNAL || tile.structure != null, (BiPredicate)BasicFluidTank.internalOnly, fluid -> fluid.getFluid().func_207185_a(FluidTags.field_206959_a), null);
        this.ventTanks = Collections.singletonList(this.ventTank);
        this.energyContainer = VariableCapacityEnergyContainer.create(() -> tile.structure == null ? FloatingLong.ZERO : this.getEnergyCapacity(), automationType -> automationType != AutomationType.EXTERNAL || tile.structure != null, (Predicate)BasicEnergyContainer.internalOnly, null);
        this.energyContainers = Collections.singletonList(this.energyContainer);
    }

    public void setTankData(@Nonnull List<IGasTank> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.gasTanks.size()) continue;
            this.gasTanks.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public void setContainerData(@Nonnull List<IEnergyContainer> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.energyContainers.size()) continue;
            this.energyContainers.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public int getDispersers() {
        return (this.volLength - 2) * (this.volWidth - 2) - 1;
    }

    public long getSteamCapacity() {
        return (long)this.lowerVolume * 64000L;
    }

    public FloatingLong getEnergyCapacity() {
        return this.energyCapacity;
    }

    public void setVolume(int volume) {
        super.setVolume(volume);
        this.energyCapacity = FloatingLong.createConst((long)((long)this.getVolume() * 16000000L));
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.gasTank.getStored(), (long)this.gasTank.getCapacity());
    }

    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }
}

