/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.FuelHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.tileentity.TileEntity;

public class TileEntityGasGenerator
extends TileEntityGenerator {
    private static final long MAX_GAS = 18000L;
    public FuelTank fuelTank;
    private long burnTicks;
    private int maxBurnTicks;
    private FloatingLong generationRate = FloatingLong.ZERO;
    private double gasUsedLastTick;
    private GasInventorySlot fuelSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityGasGenerator() {
        super((IBlockProvider)GeneratorsBlocks.GAS_BURNING_GENERATOR, ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L));
    }

    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGas(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelTank = new FuelTank((IMekanismGasHandler)this);
        builder.addTank((IChemicalTank)this.fuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelSlot = GasInventorySlot.fill((IGasTank)this.fuelTank, (IMekanismInventory)this, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IMekanismInventory)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.fuelSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        boolean operate;
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillTank();
        boolean bl = operate = (!this.fuelTank.isEmpty() || this.burnTicks > 0L) && MekanismUtils.canFunction((TileEntity)this);
        if (operate && this.getEnergyContainer().insert(this.generationRate, Action.SIMULATE, AutomationType.INTERNAL).isZero()) {
            this.setActive(true);
            if (!this.fuelTank.isEmpty()) {
                FuelHandler.FuelGas fuel = FuelHandler.getFuel((Gas)((Gas)this.fuelTank.getType()));
                this.maxBurnTicks = fuel.burnTicks;
                this.generationRate = fuel.energyPerTick;
            }
            long toUse = this.getToUse();
            FloatingLong toUseGeneration = this.generationRate.multiply(toUse);
            this.output = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).max(toUseGeneration).multiply(2L);
            long total = this.burnTicks + this.fuelTank.getStored() * (long)this.maxBurnTicks;
            total -= toUse;
            this.getEnergyContainer().insert(toUseGeneration, Action.EXECUTE, AutomationType.INTERNAL);
            if (!this.fuelTank.isEmpty()) {
                this.fuelTank.setStack(new GasStack((GasStack)this.fuelTank.getStack(), total / (long)this.maxBurnTicks));
            }
            this.burnTicks = total % (long)this.maxBurnTicks;
            this.gasUsedLastTick = (double)toUse / (double)this.maxBurnTicks;
        } else {
            if (!operate) {
                this.reset();
            }
            this.gasUsedLastTick = 0.0;
            this.setActive(false);
        }
    }

    private void reset() {
        this.burnTicks = 0L;
        this.maxBurnTicks = 0;
        this.generationRate = FloatingLong.ZERO;
        this.output = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L);
    }

    private long getToUse() {
        if (this.generationRate.isZero() || this.fuelTank.isEmpty()) {
            return 0L;
        }
        long max = (long)Math.ceil(256.0 * ((double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity()));
        max = Math.min((long)this.maxBurnTicks * this.fuelTank.getStored() + this.burnTicks, max);
        max = Math.min((long)this.getEnergyContainer().getNeeded().divide(this.generationRate).intValue(), max);
        return max;
    }

    public FloatingLong getGenerationRate() {
        return this.generationRate;
    }

    public double getUsed() {
        return (double)Math.round(this.gasUsedLastTick * 100.0) / 100.0;
    }

    public int getMaxBurnTicks() {
        return this.maxBurnTicks;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getGenerationRate, value -> {
            this.generationRate = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(() -> this.output, value -> {
            this.output = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getUsed, value -> {
            this.gasUsedLastTick = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getMaxBurnTicks, value -> {
            this.maxBurnTicks = value;
        }));
    }

    private class FuelTank
    extends BasicGasTank {
        protected FuelTank(IMekanismGasHandler gasHandler) {
            super(18000L, notExternal, alwaysTrueBi, gas -> !FuelHandler.getFuel((Gas)gas).isEmpty(), gasHandler);
        }

        public void setStack(@Nonnull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStack((ChemicalStack)stack);
            if (wasEmpty && !stack.isEmpty()) {
                TileEntityGasGenerator.this.output = FuelHandler.getFuel((Gas)((Gas)this.getType())).energyPerTick.multiply(2L);
            }
        }

        protected void setStackUnchecked(@Nonnull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStackUnchecked((ChemicalStack)stack);
            if (wasEmpty && !stack.isEmpty()) {
                TileEntityGasGenerator.this.output = FuelHandler.getFuel((Gas)((Gas)this.getType())).energyPerTick.multiply(2L);
            }
        }
    }
}

