/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityTurbineRotor
extends TileEntityInternalMultiblock {
    public int blades = 0;
    private int position = -1;
    private int radius = -1;
    public float rotationLower;
    public float rotationUpper;

    public TileEntityTurbineRotor() {
        super(GeneratorsBlocks.TURBINE_ROTOR);
    }

    public void onNeighborChange(Block block) {
        if (!this.isRemote()) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        TileEntityTurbineRotor rotor = this.getRotor(this.func_174877_v().func_177977_b());
        if (rotor == null) {
            this.scanRotors(0);
        } else {
            rotor.updateRotors();
        }
    }

    private void scanRotors(int index) {
        TileEntityTurbineRotor rotor;
        if (index != this.position) {
            this.position = index;
            this.updateRadius();
            if (this.blades > 0) {
                this.sendUpdatePacket();
            }
        }
        if ((rotor = this.getRotor(this.func_174877_v().func_177984_a())) != null) {
            rotor.scanRotors(index + 1);
        }
    }

    public boolean addBlade() {
        TileEntityTurbineRotor next = this.getRotor(this.func_174877_v().func_177977_b());
        if (next != null && next.blades < 2) {
            return next.addBlade();
        }
        if (this.blades < 2) {
            ++this.blades;
            this.sendUpdatePacket();
            return true;
        }
        next = this.getRotor(this.func_174877_v().func_177984_a());
        return next != null && next.addBlade();
    }

    public boolean removeBlade() {
        TileEntityTurbineRotor next = this.getRotor(this.func_174877_v().func_177984_a());
        if (next != null && next.blades > 0) {
            return next.removeBlade();
        }
        if (this.blades > 0) {
            --this.blades;
            this.sendUpdatePacket();
            return true;
        }
        next = this.getRotor(this.func_174877_v().func_177977_b());
        return next != null && next.removeBlade();
    }

    public int getHousedBlades() {
        return this.blades;
    }

    public int getPosition() {
        return this.position;
    }

    private void updateRadius() {
        this.radius = 1 + this.position / 4;
    }

    @Nullable
    private TileEntityTurbineRotor getRotor(BlockPos pos) {
        return (TileEntityTurbineRotor)MekanismUtils.getTileEntity(TileEntityTurbineRotor.class, (IBlockReader)this.func_145831_w(), (BlockPos)pos);
    }

    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.blades = nbtTags.func_74762_e("blades");
        this.position = nbtTags.func_74762_e("position");
        this.updateRadius();
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("blades", this.getHousedBlades());
        nbtTags.func_74768_a("position", this.getPosition());
        return nbtTags;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.blades == 0 || this.radius == -1) {
            return super.getRenderBoundingBox();
        }
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, 0, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 1, 1 + this.radius));
    }

    public void setMultiblock(UUID id) {
        super.setMultiblock(id);
        if (!this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74768_a("blades", this.blades);
        updateTag.func_74768_a("position", this.position);
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        int prevBlades = this.blades;
        int prevPosition = this.position;
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"blades", value -> {
            this.blades = value;
        });
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"position", value -> {
            this.position = value;
            this.updateRadius();
        });
        if (prevBlades != this.blades || prevPosition != prevBlades) {
            this.rotationLower = 0.0f;
            this.rotationUpper = 0.0f;
        }
    }
}

