/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing {
    public TileEntityTurbineValve() {
        super((IBlockProvider)GeneratorsBlocks.TURBINE_VALVE);
    }

    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedTurbineData)this.structure).getGasTanks(side);
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedTurbineData)this.structure).getEnergyContainers(side);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null) {
            CableUtils.emit((Set)((SynchronizedTurbineData)this.structure).getDirectionsToEmit(Coord4D.get((TileEntity)this)), (IEnergyContainer)((SynchronizedTurbineData)this.structure).energyContainer, (TileEntity)this);
        }
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public int getRedstoneLevel() {
        return this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).getCurrentRedstoneLevel();
    }
}

