/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessRecipeDamage
extends ShapelessRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new Serializer();
    private final int damageAmount;
    private final boolean ignoreUnbreaking;

    public ShapelessRecipeDamage(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs, int damageAmount, boolean ignoreUnbreaking) {
        super(id, group, output, inputs);
        this.damageAmount = damageAmount;
        this.ignoreUnbreaking = ignoreUnbreaking;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList keptItems = super.func_179532_b((IInventory)inv);
        return InventoryUtils.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.ignoreUnbreaking, this.damageAmount);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessRecipeDamage> {
        private Serializer() {
        }

        public ShapelessRecipeDamage read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputs = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int damageAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"damageAmount", (int)1);
            boolean ignoreUnbreaking = JSONUtils.func_151209_a((JsonObject)json, (String)"ignoreUnbreaking", (boolean)false);
            if (inputs.isEmpty()) {
                throw new JsonSyntaxException("No ingredients were found for the recipe!");
            }
            if (inputs.size() > 9) {
                throw new JsonSyntaxException("Too many ingredients. Maximum is 9 but " + inputs.size() + " were given.");
            }
            if (output.func_190926_b()) {
                throw new JsonSyntaxException("The output of the recipe must not be empty!");
            }
            return new ShapelessRecipeDamage(id, group, output, inputs, damageAmount, ignoreUnbreaking);
        }

        public ShapelessRecipeDamage read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            int inputCount = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)inputCount, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            int damageAmount = buffer.func_150792_a();
            boolean ignoreUnbreaking = buffer.readBoolean();
            return new ShapelessRecipeDamage(id, group, output, (NonNullList<Ingredient>)inputs, damageAmount, ignoreUnbreaking);
        }

        public void write(PacketBuffer buffer, ShapelessRecipeDamage recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.damageAmount);
            buffer.writeBoolean(recipe.ignoreUnbreaking);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray json) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement element : json) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)element);
                if (ingredient.func_203189_d()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

