/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.enchantment;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.enchantment.EnchantmentTicking;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;

public class EnchantmentAttribute
extends EnchantmentTicking {
    private final Map<IAttribute, AttributeModifier> modifiers = new HashMap<IAttribute, AttributeModifier>();

    public EnchantmentAttribute(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
    }

    public EnchantmentAttribute addAttributeModifier(IAttribute attribute, AttributeModifier modifier) {
        this.modifiers.put(attribute, modifier);
        return this;
    }

    public Map<IAttribute, AttributeModifier> getModifiers(int level) {
        return this.modifiers;
    }

    protected void removeModifiers(LivingEntity living, int level) {
        AbstractAttributeMap attributeMap = living.func_110140_aT();
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.getModifiers(level).entrySet()) {
            IAttributeInstance attribute = attributeMap.func_111151_a(entry.getKey());
            if (attribute == null) continue;
            attribute.func_111124_b(entry.getValue());
        }
    }

    protected void applyModifiers(LivingEntity living, int level) {
        AbstractAttributeMap attributeMap = living.func_110140_aT();
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.getModifiers(level).entrySet()) {
            IAttributeInstance attribute = attributeMap.func_111151_a(entry.getKey());
            AttributeModifier attributemodifier = entry.getValue();
            if (attribute == null || attribute.func_180374_a(entry.getValue())) continue;
            attribute.func_111121_a(attributemodifier);
        }
    }

    @Override
    public void onUserTick(LivingEntity user, int level) {
        this.removeModifiers(user, level);
        if (level > 0) {
            this.applyModifiers(user, level);
        }
    }
}

