/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.internal.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.internal.command.ArgumentTypeHandOutput;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class CommandHand {
    public CommandHand(LiteralArgumentBuilder<CommandSource> root) {
        root.then(Commands.func_197057_a((String)"hand").then(Commands.func_197056_a((String)"type", (ArgumentType)new ArgumentTypeHandOutput()).executes(this::hand)));
    }

    private int hand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        OutputType type = (OutputType)((Object)context.getArgument("type", OutputType.class));
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String outputText = (String)type.converter.apply(player.func_184614_ca());
        ITextComponent component = TextComponentUtils.func_197676_a((ITextComponent)new StringTextComponent(outputText).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, outputText)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.copy.click", new Object[0]))).func_179989_a(outputText)));
        ((CommandSource)context.getSource()).func_197030_a(component, false);
        return 0;
    }

    public static enum OutputType {
        STRING(OutputType::getAsString),
        JSON(OutputType::getAsJson),
        ID(OutputType::getAsID),
        HOLDER(OutputType::getAsHolder);

        private final Function<ItemStack, String> converter;

        private OutputType(Function<ItemStack, String> converter) {
            this.converter = converter;
        }

        private static String getAsString(ItemStack stack) {
            return stack.toString();
        }

        private static String getAsJson(ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)(stack.func_77942_o() ? NBTIngredient.Serializer.INSTANCE : VanillaIngredientSerializer.INSTANCE)).toString());
            json.addProperty("item", stack.func_77973_b().getRegistryName().toString());
            json.addProperty("count", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                json.addProperty("nbt", stack.func_77978_p().toString());
            }
            return json.toString();
        }

        public static String getAsID(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString();
        }

        public static String getAsHolder(ItemStack stack) {
            ResourceLocation itemId = stack.func_77973_b().getRegistryName();
            return "@ObjectHolder(\"" + itemId.toString() + "\")" + Bookshelf.NEW_LINE + "public static final Item " + itemId.func_110623_a().toUpperCase() + " = null;";
        }
    }
}

