/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CheckEnergy
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final MinMaxBounds.IntBound energy;

    public CheckEnergy(MinMaxBounds.IntBound energy) {
        this.energy = energy;
    }

    public boolean test(LootContext ctx) {
        LazyOptional energyCap;
        IEnergyStorage energyStorage;
        TileEntity tile;
        BlockPos pos = (BlockPos)ctx.func_216031_c(LootParameters.field_216286_f);
        if (pos != null && (tile = ctx.func_202879_g().func_175625_s(pos)) != null && (energyStorage = (IEnergyStorage)(energyCap = tile.getCapability(CapabilityEnergy.ENERGY)).orElse(null)) != null) {
            return this.energy.func_211339_d(energyStorage.getEnergyStored());
        }
        return false;
    }

    static class Serializer
    extends ILootCondition.AbstractSerializer<CheckEnergy> {
        Serializer() {
            super(new ResourceLocation("bookshelf", "check_forge_energy"), CheckEnergy.class);
        }

        public void serialize(JsonObject json, CheckEnergy value, JsonSerializationContext context) {
            json.add("value", value.energy.func_200321_c());
        }

        public CheckEnergy deserialize(JsonObject json, JsonDeserializationContext context) {
            return new CheckEnergy(MinMaxBounds.IntBound.func_211344_a((JsonElement)json));
        }
    }
}

