/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.loot.modifier.SerializerFactory;
import net.darkhax.bookshelf.registry.RegistryHelperClient;
import net.darkhax.bookshelf.util.LootUtils;
import net.darkhax.bookshelf.util.MCJsonUtils;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Potion;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.IStatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class RegistryHelper {
    protected final String modid;
    protected final Logger logger;
    @Nullable
    protected final ItemGroup group;
    private final List<Block> blocks = NonNullList.func_191196_a();
    private final List<Item> items = NonNullList.func_191196_a();
    private final List<TileEntityType<?>> tileEntityTypes = NonNullList.func_191196_a();
    private final List<IRecipeType<?>> recipeTypes = NonNullList.func_191196_a();
    private final List<IRecipeSerializer<?>> recipeSerializers = NonNullList.func_191196_a();
    private final List<ContainerType<?>> containers = NonNullList.func_191196_a();
    private final List<LiteralArgumentBuilder<CommandSource>> commands = NonNullList.func_191196_a();
    private final List<EntityType<?>> entityTypes = NonNullList.func_191196_a();
    private final List<Item> spawnEggs = NonNullList.func_191196_a();
    private final List<ChunkGeneratorType<?, ?>> chunkGeneratorTypes = NonNullList.func_191196_a();
    private final List<BiomeProviderType<?, ?>> biomeProviderTypes = NonNullList.func_191196_a();
    private final List<ResourceLocation> stats = NonNullList.func_191196_a();
    private final List<Potion> potions = NonNullList.func_191196_a();
    private final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>> trades = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>>();
    private final List<VillagerTrades.ITrade> basicTrades = new ArrayList<VillagerTrades.ITrade>();
    private final List<VillagerTrades.ITrade> rareTrades = new ArrayList<VillagerTrades.ITrade>();
    private final Map<String, Tuple<Class, IArgumentSerializer>> commandArguments = new HashMap<String, Tuple<Class, IArgumentSerializer>>();
    private final List<ILootCondition.AbstractSerializer<?>> lootConditions = NonNullList.func_191196_a();
    private final Map<ResourceLocation, ResourceLocation> injectionTables = new HashMap<ResourceLocation, ResourceLocation>();
    private final List<GlobalLootModifierSerializer<?>> globalModifierSerializers = NonNullList.func_191196_a();
    private final List<Enchantment> enchantments = NonNullList.func_191196_a();
    private final List<PaintingType> paintings = NonNullList.func_191196_a();
    private final Map<ResourceLocation, IIngredientSerializer<?>> ingredients = new HashMap();

    public static RegistryHelper create(String modid, Logger logger, @Nullable ItemGroup group) {
        return (RegistryHelper)DistExecutor.runForDist(() -> () -> new RegistryHelperClient(modid, logger, group), () -> () -> new RegistryHelper(modid, logger, group));
    }

    public RegistryHelper(String modid, Logger logger, @Nullable ItemGroup group) {
        this.modid = modid;
        this.logger = logger;
        this.group = group;
    }

    public void initialize(IEventBus modBus) {
        if (!this.blocks.isEmpty()) {
            modBus.addGenericListener(Block.class, this::registerBlocks);
        }
        if (!this.items.isEmpty()) {
            modBus.addGenericListener(Item.class, this::registerItems);
        }
        if (!this.tileEntityTypes.isEmpty()) {
            modBus.addGenericListener(TileEntityType.class, this::registerTileEntities);
        }
        if (!this.recipeSerializers.isEmpty() || !this.recipeTypes.isEmpty()) {
            modBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeTypes);
        }
        if (!this.containers.isEmpty()) {
            modBus.addGenericListener(ContainerType.class, this::registerContainerTypes);
        }
        if (!this.commands.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        }
        if (!this.entityTypes.isEmpty()) {
            modBus.addGenericListener(EntityType.class, this::registerEntityTypes);
        }
        if (!this.biomeProviderTypes.isEmpty()) {
            modBus.addGenericListener(BiomeProviderType.class, this::registerBiomeProviders);
        }
        if (!this.chunkGeneratorTypes.isEmpty()) {
            modBus.addGenericListener(ChunkGeneratorType.class, this::registerChunkGeneratorTypes);
        }
        if (!this.potions.isEmpty()) {
            modBus.addGenericListener(Potion.class, this::registerPotionTypes);
        }
        if (!this.trades.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        }
        if (!this.basicTrades.isEmpty() || !this.rareTrades.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerWanderingTrades);
        }
        if (!this.commandArguments.isEmpty()) {
            modBus.addListener(this::registerCommandArguments);
        }
        if (!this.lootConditions.isEmpty()) {
            modBus.addListener(this::registerLootConditions);
        }
        if (!this.injectionTables.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::loadTableInjections);
        }
        if (!this.globalModifierSerializers.isEmpty()) {
            modBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerGlobalLootModifierSerializers);
        }
        if (!this.enchantments.isEmpty()) {
            modBus.addGenericListener(Enchantment.class, this::registerEnchantments);
        }
        if (!this.paintings.isEmpty()) {
            modBus.addGenericListener(PaintingType.class, this::registerPaintings);
        }
        if (!this.ingredients.isEmpty()) {
            modBus.addGenericListener(IRecipeSerializer.class, this::registerIngredientTypes);
        }
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!this.blocks.isEmpty()) {
            this.logger.info("Registering {} blocks.", (Object)this.blocks.size());
            IForgeRegistry registry = event.getRegistry();
            for (Block block : this.blocks) {
                registry.register((IForgeRegistryEntry)block);
            }
        }
    }

    public Block registerBlock(Block block, String id) {
        return this.registerBlock(block, new BlockItem(block, new Item.Properties().func_200916_a(this.group)), id);
    }

    public Block registerBlock(Block block, BlockItem item, String id) {
        block.setRegistryName(new ResourceLocation(this.modid, id));
        this.blocks.add(block);
        this.registerItem((Item)item, id);
        return block;
    }

    public List<Block> getBlocks() {
        return ImmutableList.copyOf(this.blocks);
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        if (!this.items.isEmpty()) {
            this.logger.info("Registering {} items.", (Object)this.items.size());
            IForgeRegistry registry = event.getRegistry();
            for (Item item : this.items) {
                registry.register((IForgeRegistryEntry)item);
            }
        }
    }

    public Item registerItem(Item item, String id) {
        item.setRegistryName(new ResourceLocation(this.modid, id));
        item.field_77701_a = this.group;
        this.items.add(item);
        return item;
    }

    public List<Item> getItems() {
        return ImmutableList.copyOf(this.items);
    }

    public <T extends TileEntity> TileEntityType<T> registerTileEntity(Supplier<T> factory, String id, Block ... blocks) {
        TileEntityType tileEntityType = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null);
        tileEntityType.setRegistryName(this.modid, id);
        this.tileEntityTypes.add(tileEntityType);
        return tileEntityType;
    }

    private void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        if (!this.tileEntityTypes.isEmpty()) {
            this.logger.info("Registering {} tile entity types.", (Object)this.tileEntityTypes.size());
            IForgeRegistry registry = event.getRegistry();
            for (TileEntityType<?> tileEntityType : this.tileEntityTypes) {
                registry.register(tileEntityType);
            }
        }
    }

    public List<TileEntityType<?>> getTileEntities() {
        return ImmutableList.copyOf(this.tileEntityTypes);
    }

    public <T extends IRecipe<?>> IRecipeType<T> registerRecipeType(String typeId) {
        IRecipeType type = IRecipeType.func_222147_a((String)typeId);
        this.recipeTypes.add(type);
        return type;
    }

    public <T extends IRecipe<?>> IRecipeSerializer<T> registerRecipeSerializer(IRecipeSerializer<T> serializer, String id) {
        this.recipeSerializers.add(serializer);
        serializer.setRegistryName(new ResourceLocation(this.modid, id));
        return serializer;
    }

    private void registerRecipeTypes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        if (!this.recipeTypes.isEmpty()) {
            this.logger.info("Registering {} recipe types.", (Object)this.recipeTypes.size());
            for (IRecipeType<?> recipeType : this.recipeTypes) {
                Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(recipeType.toString()), recipeType);
            }
        }
        if (!this.recipeSerializers.isEmpty()) {
            this.logger.info("Registering {} recipe serializers.", (Object)this.recipeSerializers.size());
            IForgeRegistry registry = event.getRegistry();
            for (IRecipeSerializer<?> serializer : this.recipeSerializers) {
                registry.register(serializer);
            }
        }
    }

    public List<IRecipeType<?>> getRecipeTypes() {
        return ImmutableList.copyOf(this.recipeTypes);
    }

    public List<IRecipeSerializer<?>> getRecipeSerializers() {
        return ImmutableList.copyOf(this.recipeSerializers);
    }

    public <T extends Container> ContainerType<T> registerContainer(ContainerType.IFactory<T> factory, String id) {
        return this.registerContainer(new ContainerType(factory), id);
    }

    public <T extends Container> ContainerType<T> registerContainer(ContainerType<T> type, String id) {
        type.setRegistryName(this.modid, id);
        this.containers.add(type);
        return type;
    }

    protected void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        if (!this.containers.isEmpty()) {
            this.logger.info("Registering {} containers.", (Object)this.containers.size());
            IForgeRegistry registry = event.getRegistry();
            for (ContainerType<?> containerType : this.containers) {
                registry.register(containerType);
            }
        }
    }

    public List<ContainerType<?>> getContainers() {
        return ImmutableList.copyOf(this.containers);
    }

    public LiteralArgumentBuilder<CommandSource> registerCommand(LiteralArgumentBuilder<CommandSource> command) {
        this.commands.add(command);
        return command;
    }

    private void registerCommands(FMLServerStartingEvent event) {
        if (!this.commands.isEmpty()) {
            this.logger.info("Registering {} commands.", (Object)this.commands.size());
            CommandDispatcher dispatcher = event.getCommandDispatcher();
            for (LiteralArgumentBuilder<CommandSource> command : this.commands) {
                dispatcher.register(command);
            }
        }
    }

    public List<LiteralArgumentBuilder<CommandSource>> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }

    public <T extends Entity> EntityType<T> registerMob(Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, String id, float width, float height, int primary, int secondary) {
        return this.registerMob(entityClass, factory, classification, id, width, height, 64, 1, primary, secondary);
    }

    public <T extends Entity> EntityType<T> registerMob(Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, String id, float width, float height, int trackingRange, int updateInterval, int primary, int secondary) {
        EntityType<T> type = this.registerEntityType(entityClass, factory, classification, id, width, height, trackingRange, updateInterval);
        SpawnEggItem spawnEgg = new SpawnEggItem(type, primary, secondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        spawnEgg.setRegistryName(this.modid, id + "_spawn_egg");
        this.items.add((Item)spawnEgg);
        this.spawnEggs.add((Item)spawnEgg);
        return type;
    }

    public <T extends Entity> EntityType<T> registerEntityType(Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, String id, float width, float height) {
        return this.registerEntityType(entityClass, factory, classification, id, width, height, 64, 1);
    }

    public <T extends Entity> EntityType<T> registerEntityType(Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, String id, float width, float height, int trackingRange, int updateInterval) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.func_220321_a(width, height);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateInterval);
        return this.registerEntityType(builder.func_206830_a(this.modid + ":" + id), id);
    }

    public <T extends Entity> EntityType<T> registerEntityType(EntityType<T> type, String id) {
        this.entityTypes.add(type);
        type.setRegistryName(this.modid, id);
        return type;
    }

    public List<EntityType<?>> getEntityTypes() {
        return ImmutableList.copyOf(this.entityTypes);
    }

    public List<Item> getSpawnEggs() {
        return ImmutableList.copyOf(this.spawnEggs);
    }

    protected void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        if (!this.entityTypes.isEmpty()) {
            this.logger.info("Registering {} entity types.", (Object)this.entityTypes.size());
            IForgeRegistry registry = event.getRegistry();
            for (EntityType<?> entityType : this.entityTypes) {
                registry.register(entityType);
            }
        }
    }

    public <C extends GenerationSettings, T extends ChunkGenerator<C>> ChunkGeneratorType<C, T> registerChunkGeneratorType(ChunkGeneratorType<C, T> type, String id) {
        this.chunkGeneratorTypes.add(type);
        type.setRegistryName(this.modid, id);
        return type;
    }

    private void registerChunkGeneratorTypes(RegistryEvent.Register<ChunkGeneratorType<?, ?>> event) {
        if (!this.chunkGeneratorTypes.isEmpty()) {
            this.logger.info("Registering {} chunk generator types.", (Object)this.chunkGeneratorTypes.size());
            IForgeRegistry registry = event.getRegistry();
            for (ChunkGeneratorType<?, ?> containerType : this.chunkGeneratorTypes) {
                registry.register(containerType);
            }
        }
    }

    public <C extends IBiomeProviderSettings, T extends BiomeProvider> BiomeProviderType<C, T> registerBiomeProvider(BiomeProviderType<C, T> type, String id) {
        this.biomeProviderTypes.add(type);
        type.setRegistryName(this.modid, id);
        return type;
    }

    private void registerBiomeProviders(RegistryEvent.Register<BiomeProviderType<?, ?>> event) {
        if (!this.biomeProviderTypes.isEmpty()) {
            this.logger.info("Registering {} biome provider types.", (Object)this.biomeProviderTypes.size());
            IForgeRegistry registry = event.getRegistry();
            for (BiomeProviderType<?, ?> containerType : this.biomeProviderTypes) {
                registry.register(containerType);
            }
        }
    }

    public ResourceLocation registerStat(String key) {
        return this.registerStat(key, IStatFormatter.field_223218_b_);
    }

    public ResourceLocation registerStat(String key, IStatFormatter formatter) {
        ResourceLocation statIdentifier = new ResourceLocation(this.modid, key);
        Registry.func_218325_a((Registry)Registry.field_212623_l, (String)key, (Object)statIdentifier);
        Stats.field_199092_j.func_199077_a((Object)statIdentifier, formatter);
        this.stats.add(statIdentifier);
        return statIdentifier;
    }

    public List<ResourceLocation> getStatIdentifiers() {
        return ImmutableList.copyOf(this.stats);
    }

    public Potion registerPotion(Potion potion, String id) {
        this.potions.add(potion);
        potion.setRegistryName(this.modid, id);
        return potion;
    }

    private void registerPotionTypes(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        this.logger.info("Registering {} potion types.", (Object)this.potions.size());
        for (Potion potion : this.potions) {
            registry.register((IForgeRegistryEntry)potion);
        }
    }

    public List<Potion> getPotions() {
        return ImmutableList.copyOf(this.potions);
    }

    public VillagerTrades.ITrade registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ITrade trade) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> tradesByLevel = this.trades.getOrDefault(profession, (Int2ObjectMap<List<VillagerTrades.ITrade>>)new Int2ObjectOpenHashMap());
        List tradesForLevel = (List)tradesByLevel.getOrDefault(level, new ArrayList());
        tradesForLevel.add(trade);
        tradesByLevel.put(level, (Object)tradesForLevel);
        this.trades.put(profession, tradesByLevel);
        return trade;
    }

    private void registerVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> tradesByLevel;
        if (event.getType() != null && (tradesByLevel = this.trades.get(event.getType())) != null && !tradesByLevel.isEmpty()) {
            IntIterator intIterator = tradesByLevel.keySet().iterator();
            while (intIterator.hasNext()) {
                int level = (Integer)intIterator.next();
                List tradeRegistry = (List)event.getTrades().get(level);
                if (tradeRegistry != null) {
                    tradeRegistry.addAll((Collection)tradesByLevel.get(level));
                    continue;
                }
                this.logger.error("The mod {} tried to register a trade at profession level {} for villager type {}. This profession level does not exist!", (Object)this.modid, (Object)level, (Object)event.getType().getRegistryName().toString());
            }
        }
    }

    public VillagerTrades.ITrade addBasicWanderingTrade(VillagerTrades.ITrade trade) {
        this.basicTrades.add(trade);
        return trade;
    }

    public VillagerTrades.ITrade addRareWanderingTrade(VillagerTrades.ITrade trade) {
        this.rareTrades.add(trade);
        return trade;
    }

    private void registerWanderingTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(this.basicTrades);
        event.getRareTrades().addAll(this.rareTrades);
    }

    public <T extends ArgumentType<?>> void registerCommandArgument(String name, Class<T> clazz, IArgumentSerializer<T> serializer) {
        this.commandArguments.put(name, (Tuple<Class, IArgumentSerializer>)new Tuple(clazz, serializer));
    }

    private void registerCommandArguments(FMLCommonSetupEvent event) {
        this.logger.info("Registering {} command argument types.", (Object)this.commandArguments.size());
        for (Map.Entry<String, Tuple<Class, IArgumentSerializer>> entry : this.commandArguments.entrySet()) {
            ArgumentTypes.func_218136_a((String)entry.getKey(), (Class)((Class)entry.getValue().func_76341_a()), (IArgumentSerializer)((IArgumentSerializer)entry.getValue().func_76340_b()));
        }
    }

    public void registerLootCondition(ILootCondition.AbstractSerializer<?> condition) {
        this.lootConditions.add(condition);
    }

    private void registerLootConditions(FMLCommonSetupEvent event) {
        this.logger.info("Registering {} loot condition types.", (Object)this.lootConditions.size());
        for (ILootCondition.AbstractSerializer<?> entry : this.lootConditions) {
            LootConditionManager.func_186639_a(entry);
        }
    }

    public ResourceLocation injectTable(ResourceLocation toInject) {
        ResourceLocation injectId = new ResourceLocation(this.modid, "inject/" + toInject.func_110624_b() + "/" + toInject.func_110623_a());
        this.injectionTables.put(toInject, injectId);
        return injectId;
    }

    private void loadTableInjections(LootTableLoadEvent event) {
        ResourceLocation injectTableName = this.injectionTables.get(event.getName());
        if (injectTableName != null) {
            LootTable originalTable = event.getTable();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                try {
                    LootTable inject = MCJsonUtils.loadLootTable(event.getLootTableManager(), (IResourceManager)server.func_195570_aG(), injectTableName);
                    if (inject != null) {
                        this.logger.info("Injecting loot table {} with {}.", (Object)event.getName(), (Object)injectTableName);
                        this.mergeTables(originalTable, event.getName(), inject, injectTableName);
                    }
                }
                catch (IOException e) {
                    this.logger.error("Failed to load {} as a loot table.", (Object)injectTableName, (Object)e);
                }
            }
        }
    }

    private void mergeTables(LootTable original, ResourceLocation originalName, LootTable mergeWith, ResourceLocation mergeWithName) {
        List<LootPool> pools = LootUtils.getPools(original);
        Map<String, LootPool> mappedPools = LootUtils.mapPools(pools);
        for (LootPool poolToInject : LootUtils.getPools(mergeWith)) {
            String poolName = poolToInject.getName();
            if (mappedPools.containsKey(poolToInject.getName())) {
                LootPool originalPool = mappedPools.get(poolName);
                this.logger.info("Merged pool {} into {} from {}.", (Object)originalPool.getName(), (Object)originalName, (Object)mergeWithName);
                LootUtils.getEntries(originalPool).addAll(LootUtils.getEntries(poolToInject));
                LootUtils.getConditions(originalPool).addAll(LootUtils.getConditions(poolToInject));
                continue;
            }
            pools.add(poolToInject);
            this.logger.info("Injected new pool {} into table {}.", (Object)poolName, (Object)originalName);
        }
    }

    public <T extends IGlobalLootModifier> GlobalLootModifierSerializer<T> registerGlobalModifier(Function<ILootCondition[], T> factory, String id) {
        return this.registerGlobalModifier(new SerializerFactory<T>(factory), id);
    }

    public <T extends IGlobalLootModifier> GlobalLootModifierSerializer<T> registerGlobalModifier(GlobalLootModifierSerializer<T> serializer, String id) {
        serializer.setRegistryName(this.modid, id);
        this.globalModifierSerializers.add(serializer);
        return serializer;
    }

    private void registerGlobalLootModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        this.logger.info("Registering {} global loot modifier serializers.", (Object)this.globalModifierSerializers.size());
        IForgeRegistry registry = event.getRegistry();
        for (GlobalLootModifierSerializer<?> entry : this.globalModifierSerializers) {
            registry.register(entry);
        }
    }

    public <T extends Enchantment> T registerEnchantment(T enchantment, String id) {
        enchantment.setRegistryName(this.modid, id);
        this.enchantments.add(enchantment);
        return enchantment;
    }

    public List<Enchantment> getEnchantments() {
        return ImmutableList.copyOf(this.enchantments);
    }

    private void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        this.logger.info("Registering {} enchantments.", (Object)this.enchantments.size());
        IForgeRegistry registry = event.getRegistry();
        for (Enchantment entry : this.enchantments) {
            registry.register((IForgeRegistryEntry)entry);
        }
    }

    public PaintingType registerPainting(String id, int width, int height) {
        return this.registerPainting(new PaintingType(width, height), id);
    }

    public <T extends PaintingType> T registerPainting(T painting, String id) {
        painting.setRegistryName(this.modid, id);
        this.paintings.add(painting);
        return painting;
    }

    public List<PaintingType> getPaintings() {
        return ImmutableList.copyOf(this.paintings);
    }

    private void registerPaintings(RegistryEvent.Register<PaintingType> event) {
        this.logger.info("Registering {} paintings.", (Object)this.paintings.size());
        IForgeRegistry registry = event.getRegistry();
        for (PaintingType entry : this.paintings) {
            registry.register((IForgeRegistryEntry)entry);
        }
    }

    public void registerIngredientType(IIngredientSerializer<?> serializer, String id) {
        this.ingredients.put(new ResourceLocation(this.modid, id), serializer);
    }

    private void registerIngredientTypes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        this.logger.info("Registering {} ingredient serializers.", (Object)this.ingredients.size());
        for (Map.Entry<ResourceLocation, IIngredientSerializer<?>> entry : this.ingredients.entrySet()) {
            CraftingHelper.register((ResourceLocation)entry.getKey(), entry.getValue());
        }
    }
}

