/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class RegistryHelperClient
extends RegistryHelper {
    private final Multimap<ResourceLocation, ResourceLocation> sprites = ArrayListMultimap.create();

    public RegistryHelperClient(String modid, Logger logger, ItemGroup group) {
        super(modid, logger, group);
    }

    @Override
    public void initialize(IEventBus modBus) {
        super.initialize(modBus);
        if (!this.sprites.isEmpty()) {
            modBus.addListener(this::registerSprites);
        }
    }

    public ResourceLocation registerSprite(ResourceLocation atlas, String sprite) {
        return this.registerSprite(atlas, new ResourceLocation(this.modid, sprite));
    }

    public ResourceLocation registerSprite(ResourceLocation atlas, ResourceLocation sprite) {
        this.sprites.put((Object)atlas, (Object)sprite);
        return sprite;
    }

    private void registerSprites(TextureStitchEvent.Pre event) {
        for (ResourceLocation toAdd : this.sprites.get((Object)event.getMap().func_229223_g_())) {
            event.addSprite(toAdd);
        }
    }
}

