/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.client.RecipeSelectionManager;

public class ClientEventHandler {
    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent evt) {
        ClientWorld world;
        if (evt.phase == TickEvent.Phase.END && (world = Minecraft.func_71410_x().field_71441_e) != null) {
            RecipeSelectionManager.getInstance().ifPresent(RecipeSelectionManager::tick);
        }
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen screen = evt.getGui();
        RecipeSelectionManager conflictManager = null;
        if (screen instanceof ContainerScreen) {
            ContainerScreen containerScreen = (ContainerScreen)screen;
            conflictManager = PolymorphApi.getProvider(containerScreen.func_212873_a_()).map(provider -> {
                if (provider.getCraftingInventory() != null && provider.isActive()) {
                    return RecipeSelectionManager.createInstance(containerScreen, provider);
                }
                return null;
            }).orElse(null);
        }
        if (conflictManager == null) {
            RecipeSelectionManager.clearInstance();
        }
    }

    @SubscribeEvent
    public void guiRender(GuiScreenEvent.DrawScreenEvent.Post evt) {
        if (evt.getGui() instanceof ContainerScreen) {
            RecipeSelectionManager.getInstance().ifPresent(conflictManager -> conflictManager.render(evt.getMouseX(), evt.getMouseY(), evt.getRenderPartialTicks()));
        }
    }

    @SubscribeEvent
    public void guiMouseClick(GuiScreenEvent.MouseClickedEvent.Pre evt) {
        if (evt.getGui() instanceof ContainerScreen) {
            RecipeSelectionManager.getInstance().ifPresent(RecipeSelectionManager::markPositionChanged);
            if (RecipeSelectionManager.getInstance().map(conflictManager -> conflictManager.mouseClicked(evt.getMouseX(), evt.getMouseY(), evt.getButton())).orElse(false).booleanValue()) {
                evt.setCanceled(true);
            }
        }
    }
}

