/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integrations.storagenetwork;

import com.lothrazar.storagenetwork.block.request.ContainerNetworkCraftingTable;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.gui.NetworkCraftingInventory;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.PolyProvider;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integrations.CompatibilityModule;

public class StorageNetworkModule
extends CompatibilityModule {
    @Override
    public void setup() {
        PolymorphApi.addProvider(ContainerNetworkCraftingTable.class, StorageNetworkProvider::new);
        PolymorphApi.addProvider(ContainerNetworkCraftingRemote.class, StorageNetworkProvider::new);
    }

    public static class StorageNetworkProvider<T extends ContainerNetwork>
    implements PolyProvider {
        private final T containerNetwork;

        public StorageNetworkProvider(T containerNetwork) {
            this.containerNetwork = containerNetwork;
        }

        @Override
        public Container getContainer() {
            return this.containerNetwork;
        }

        @Override
        public int getXOffset() {
            return 13;
        }

        @Override
        public int getYOffset() {
            return -22;
        }

        @Override
        public void transfer(PlayerEntity playerIn, ICraftingRecipe recipe) {
            Container container = this.getContainer();
            Slot slot = this.getOutputSlot();
            if (slot.func_75216_d() && container instanceof ContainerNetwork) {
                StorageNetworkProvider.craftShift(container, playerIn, recipe);
            }
        }

        public static void craftShift(Container container, PlayerEntity player, ICraftingRecipe recipe) {
            if (container instanceof ContainerNetwork) {
                ContainerNetwork containerNetwork = (ContainerNetwork)container;
                if (!containerNetwork.isCrafting() || containerNetwork.matrix == null) {
                    return;
                }
                Field f = null;
                try {
                    f = ContainerNetwork.class.getDeclaredField("recipeLocked");
                    f.setAccessible(true);
                    f.set(containerNetwork, true);
                }
                catch (Exception e) {
                    Polymorph.LOGGER.error("Reflection error!", (Throwable)e);
                }
                NetworkCraftingInventory matrix = containerNetwork.matrix;
                ItemStack res = recipe.func_77572_b((IInventory)matrix);
                int crafted = 0;
                ArrayList<ItemStack> recipeCopy = new ArrayList<ItemStack>();
                for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                    recipeCopy.add(matrix.func_70301_a(i).func_77946_l());
                }
                int sizePerCraft = res.func_190916_E();
                while (crafted + sizePerCraft <= res.func_77976_d() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), (ItemStack)(res = recipe.func_77572_b((IInventory)matrix)), (boolean)true).func_190926_b() && recipe.func_77569_a((IInventory)matrix, player.field_70170_p)) {
                    if (!player.field_71071_by.func_70441_a(res)) {
                        player.func_71019_a(res, false);
                    }
                    NonNullList remainder = recipe.func_179532_b((IInventory)matrix);
                    for (int i = 0; i < remainder.size(); ++i) {
                        ItemStack remainderCurrent = (ItemStack)remainder.get(i);
                        ItemStack slot = matrix.func_70301_a(i);
                        if (remainderCurrent.func_190926_b()) {
                            matrix.func_70301_a(i).func_190918_g(1);
                            continue;
                        }
                        if (slot.func_77973_b().func_77668_q() != null) {
                            slot = new ItemStack((IItemProvider)slot.func_77973_b().func_77668_q());
                            matrix.func_70299_a(i, slot);
                            continue;
                        }
                        if (!slot.func_77973_b().getContainerItem(slot).func_190926_b()) {
                            slot = slot.func_77973_b().getContainerItem(slot);
                            matrix.func_70299_a(i, slot);
                            continue;
                        }
                        if (!remainderCurrent.func_190926_b()) {
                            if (slot.func_190926_b()) {
                                matrix.func_70299_a(i, remainderCurrent);
                                continue;
                            }
                            if (ItemStack.func_179545_c((ItemStack)slot, (ItemStack)remainderCurrent) && ItemStack.func_77970_a((ItemStack)slot, (ItemStack)remainderCurrent)) {
                                remainderCurrent.func_190917_f(slot.func_190916_E());
                                matrix.func_70299_a(i, remainderCurrent);
                                continue;
                            }
                            if (ItemStack.func_185132_d((ItemStack)slot, (ItemStack)remainderCurrent)) {
                                matrix.func_70299_a(i, remainderCurrent);
                                continue;
                            }
                            if (player.field_71071_by.func_70441_a(remainderCurrent)) continue;
                            player.func_71019_a(remainderCurrent, false);
                            continue;
                        }
                        if (slot.func_190926_b()) continue;
                        matrix.func_70298_a(i, 1);
                    }
                    crafted += sizePerCraft;
                    for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                        ItemStack stackInSlot = matrix.func_70301_a(i);
                        if (!stackInSlot.func_190926_b()) continue;
                        ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                        ItemStackMatcher itemStackMatcherCurrent = !recipeStack.func_190926_b() ? new ItemStackMatcher(recipeStack, false, false) : null;
                        ItemStack req = containerNetwork.getTileMain().request(itemStackMatcherCurrent, 1, false);
                        matrix.func_70299_a(i, req);
                    }
                    container.func_75130_a((IInventory)matrix);
                }
                container.func_75142_b();
                if (f != null) {
                    try {
                        f.set(containerNetwork, false);
                    }
                    catch (IllegalAccessException e) {
                        Polymorph.LOGGER.error("Reflection error!", (Throwable)e);
                    }
                }
                container.func_75130_a((IInventory)matrix);
            }
        }
    }
}

