/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class FeatureConfig {
    private String name;
    private double chance;
    private List<String> biomes;
    private ForgeConfigSpec.DoubleValue configChance;
    private ForgeConfigSpec.ConfigValue<String> configBiomes;

    public FeatureConfig(String name, double chance, List<String> biomes) {
        this.name = name;
        this.chance = chance;
        this.biomes = biomes;
    }

    public float getChance() {
        return (float)((Double)this.configChance.get()).doubleValue();
    }

    public List<String> getBiomes() {
        String values = (String)this.configBiomes.get();
        return Arrays.asList(values.split(","));
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " spawn config.").push(this.name + "_spawn");
        this.configChance = builder.comment("Percent chance to spawn (set to 0 to disable) per chunk.").defineInRange("spawnChance", this.chance, 0.0, 1.0);
        StringBuilder sb = new StringBuilder();
        this.biomes.forEach(biome -> {
            sb.append((String)biome);
            sb.append(",");
        });
        this.configBiomes = builder.comment("List of biome types to spawn.").define("biomes", (Object)sb.toString());
        builder.pop();
    }
}

