/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.integration.patchouli.api;

import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.config.MobConfig;
import epicsquid.mysticalworld.integration.patchouli.api.StandardDrops;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class AnimalSpawnInfo
implements IComponentProcessor {
    private String animalName;
    private MobConfig animal;

    public void setup(IVariableProvider<String> iVariableProvider) {
        String name;
        this.animalName = name = (String)iVariableProvider.get("animal");
        switch (name) {
            case "deer": {
                this.animal = ConfigManager.DEER_CONFIG;
                break;
            }
            case "frog": {
                this.animal = ConfigManager.FROG_CONFIG;
                break;
            }
            case "sprout": {
                this.animal = ConfigManager.SPROUT_CONFIG;
                break;
            }
            case "beetle": {
                this.animal = ConfigManager.BEETLE_CONFIG;
                break;
            }
            case "fox": {
                this.animal = ConfigManager.SILVER_FOX_CONFIG;
                break;
            }
            case "endermini": {
                this.animal = ConfigManager.ENDERMINI_CONFIG;
                break;
            }
            case "lava_cat": {
                this.animal = ConfigManager.LAVA_CAT_CONFIG;
                break;
            }
            case "owl": {
                this.animal = ConfigManager.OWL_CONFIG;
                break;
            }
            case "hell_sprout": {
                this.animal = ConfigManager.HELL_SPROUT_CONFIG;
                break;
            }
            default: {
                this.animal = null;
            }
        }
    }

    public String process(String s) {
        if (this.animal == null && !this.animalName.equals("squid")) {
            return null;
        }
        if (s.startsWith("groupSize")) {
            if (this.animalName.equals("squid")) {
                return "Standard group sizes.";
            }
            return String.format("Groups of: %d-%d", this.animal.getMin(), this.animal.getMax());
        }
        if (s.startsWith("biomes")) {
            if (this.animalName.equals("squid")) {
                return "Default biomes.";
            }
            if (this.animalName.equals("endermini")) {
                return "The End";
            }
            StringJoiner joiner = new StringJoiner(", ");
            for (String biomeName : this.animal.getBiomes()) {
                joiner.add(WordUtils.capitalize((String)biomeName.toLowerCase()));
            }
            return "Biomes tagged with: " + joiner.toString();
        }
        if (s.startsWith("title")) {
            if (this.animalName.contains("_")) {
                return WordUtils.capitalize((String)this.animalName.replace("_", " "));
            }
            return WordUtils.capitalize((String)this.animalName.toLowerCase());
        }
        if (s.startsWith("item")) {
            List<ItemStack> drops = StandardDrops.getDrops(this.animalName);
            int index = Integer.parseInt(s.replace("item", "")) - 1;
            if (index < drops.size()) {
                return ItemStackUtil.serializeStack((ItemStack)drops.get(index));
            }
            return ItemStackUtil.serializeStack((ItemStack)ItemStack.field_190927_a);
        }
        return null;
    }
}

