/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.items;

import com.google.common.collect.Multimap;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.entity.SpiritDeerEntity;
import epicsquid.mysticalworld.entity.model.ModelHolder;
import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModMaterials;
import epicsquid.mysticalworld.items.ModifiedArmorItem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noobanidus.libs.repack_mysticalworld.noobutil.material.MaterialType;

public class AntlerHatItem
extends ModifiedArmorItem {
    public static AxisAlignedBB BOX = new AxisAlignedBB(-8.0, -8.0, -8.0, 9.0, 9.0, 9.0);

    public AntlerHatItem(Item.Properties builder) {
        super(ModMaterials.ANTLER.getArmorMaterial(), EquipmentSlotType.HEAD, builder);
    }

    @Override
    public Map<IAttribute, AttributeModifier> getModifiers() {
        return super.getModifiers();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap map = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.HEAD && ConfigManager.HAT_CONFIG.getAntlerHealthBonus() != -1.0f) {
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)this.getOrCreateModifier(SharedMonsterAttributes.field_111267_a, () -> new AttributeModifier(MaterialType.ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()], "Antler Health Boost", (double)ConfigManager.HAT_CONFIG.getAntlerHealthBonus(), AttributeModifier.Operation.ADDITION)));
        }
        return map;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (ConfigManager.HAT_CONFIG.getAntlerFrequency() == -1) {
            return;
        }
        if (!world.field_72995_K) {
            float f = player.func_110143_aJ();
            float f2 = ConfigManager.HAT_CONFIG.getAntlerThreshold() == -1 ? player.func_110138_aP() : player.func_110138_aP() - (float)ConfigManager.HAT_CONFIG.getAntlerThreshold();
            if (f < f2 && world.field_73012_v.nextInt(ConfigManager.HAT_CONFIG.getAntlerFrequency()) == 0) {
                BlockPos pos;
                if (player.func_70660_b(Effects.field_76428_l) != null) {
                    return;
                }
                BlockPos playerPos = player.func_180425_c();
                if (!world.func_217357_a(SpiritDeerEntity.class, BOX.func_186670_a(playerPos)).isEmpty()) {
                    return;
                }
                int tries = 100;
                do {
                    if (--tries > 0) continue;
                    return;
                } while (!world.func_175623_d(pos = playerPos.func_177982_a(world.field_73012_v.nextInt(8) - 4, 0, world.field_73012_v.nextInt(8) - 4)) || player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 9.0);
                SpiritDeerEntity spiritDeer = (SpiritDeerEntity)ModEntities.SPIRIT_DEER.get().func_200721_a(world);
                if (spiritDeer != null) {
                    spiritDeer.func_70624_b((LivingEntity)player);
                    spiritDeer.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                    spiritDeer.field_70145_X = true;
                    world.func_217376_c((Entity)spiritDeer);
                    ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
                    if (ConfigManager.HAT_CONFIG.getAntlerDamage() != -1) {
                        head.func_222118_a(ConfigManager.HAT_CONFIG.getAntlerDamage(), (LivingEntity)player, breaker -> breaker.func_213361_c(EquipmentSlotType.HEAD));
                    }
                }
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "mysticalworld:textures/models/armor/antler_hat.png";
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)ModelHolder.antlerHatModel);
    }
}

