/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageOpenBookGui;

public class GuideItem
extends Item {
    private static final ResourceLocation ENCYCLOPEDIA = new ResourceLocation("mysticalworld", "world_guide");

    public GuideItem(Item.Properties properties) {
        super(properties);
    }

    public static Book getBook() {
        return (Book)BookRegistry.INSTANCE.books.get(ENCYCLOPEDIA);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Book book = GuideItem.getBook();
        return book != null ? new TranslationTextComponent(book.name, new Object[0]) : super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Book book = GuideItem.getBook();
        if (book != null && book.contents != null) {
            tooltip.add(new StringTextComponent(book.contents.getSubtitle()).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Book book = GuideItem.getBook();
        if (book == null) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (playerIn instanceof ServerPlayerEntity) {
            NetworkHandler.sendToPlayer((Object)new MessageOpenBookGui(book.id, null), (ServerPlayerEntity)((ServerPlayerEntity)playerIn));
            SoundEvent sfx = PatchouliSounds.getSound((ResourceLocation)book.openSound, (SoundEvent)PatchouliSounds.book_open);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }
}

