/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.recipe;

import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import noobanidus.libs.repack_mysticalworld.noobutil.util.MathUtil;

public interface IDamageRecipe {
    public static final String TAG = "damage_item";
    public static final String DAMAGE = "damage_amount";

    default public Ingredient createDamageIngredient(Ingredient ingredient) {
        ArrayList<ItemStack> matchingStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (!stack.func_77984_f()) {
                throw new IllegalArgumentException("Invalid itemstack '" + stack.toString() + "' for DamageRecipe: flagged as damage item, but not damageable.");
            }
            for (int i = 0; i < stack.func_77958_k(); ++i) {
                ItemStack copy = stack.func_77946_l();
                copy.func_196085_b(i);
                matchingStacks.add(copy);
            }
        }
        return Ingredient.func_193369_a((ItemStack[])matchingStacks.toArray(new ItemStack[0]));
    }

    default public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv, Ingredient damageIngredient, int damageAmount) {
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < result.size(); ++i) {
            ItemStack current = inv.func_70301_a(i);
            if (current.func_190926_b() || !damageIngredient.test(current)) continue;
            if ((current = current.func_77946_l()).func_96631_a(damageAmount, MathUtil.rand, null)) {
                current.func_190920_e(0);
            }
            if (current.func_190926_b()) continue;
            result.set(i, (Object)current);
        }
        return result;
    }
}

