/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.builders;

import com.google.common.base.Preconditions;
import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.BlockBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticalworld.repack.registrate.builders.ItemBuilder;
import epicsquid.mysticalworld.repack.registrate.providers.ProviderType;
import epicsquid.mysticalworld.repack.registrate.util.NonNullLazyValue;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullBiFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullConsumer;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidBuilder<T extends ForgeFlowingFluid, P>
extends AbstractBuilder<Fluid, T, P, FluidBuilder<T, P>> {
    private final ResourceLocation stillTexture;
    private final String sourceName;
    private final String bucketName;
    private final NonNullSupplier<FluidAttributes.Builder> attributes;
    private final NonNullFunction<ForgeFlowingFluid.Properties, T> factory;
    private NonNullConsumer<FluidAttributes.Builder> attributesCallback = $ -> {};
    private NonNullConsumer<ForgeFlowingFluid.Properties> properties;
    @Nullable
    private NonNullLazyValue<? extends ForgeFlowingFluid> source;
    private List<Tag<Fluid>> tags = new ArrayList<Tag<Fluid>>();

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, (NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes>)null);
    }

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, ForgeFlowingFluid.Flowing::new);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, null, factory);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, factory).defaultSource().defaultBlock().defaultBucket().tag(FluidTags.field_206959_a);
        return ret;
    }

    protected FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        super(owner, parent, "flowing_" + name, callback, Fluid.class);
        this.stillTexture = stillTexture;
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.attributes = () -> attributesFactory == null ? FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture) : new Builder(stillTexture, flowingTexture, attributesFactory);
        this.factory = factory;
        String bucketName = this.bucketName;
        this.properties = p -> p.bucket(() -> (Item)owner.get(bucketName, Item.class).get()).block(() -> (FlowingFluidBlock)owner.get(name, Block.class).get());
    }

    public FluidBuilder<T, P> attributes(NonNullConsumer<FluidAttributes.Builder> cons) {
        this.attributesCallback = this.attributesCallback.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<ForgeFlowingFluid.Properties> cons) {
        this.properties = this.properties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> defaultSource() {
        return this.source(ForgeFlowingFluid.Source::new);
    }

    public FluidBuilder<T, P> source(NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid> factory) {
        this.source = new NonNullLazyValue<ForgeFlowingFluid>(() -> (ForgeFlowingFluid)factory.apply(this.makeProperties()));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        return (FluidBuilder)this.block().build();
    }

    public BlockBuilder<FlowingFluidBlock, FluidBuilder<T, P>> block() {
        return this.block(FlowingFluidBlock::new);
    }

    public <B extends FlowingFluidBlock> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, Block.Properties, ? extends B> factory) {
        NonNullSupplier supplier = this.asSupplier();
        return this.getOwner().block(this, this.sourceName, p -> (FlowingFluidBlock)factory.apply(supplier, (Block.Properties)p)).properties(p -> Block.Properties.func_200950_a((Block)Blocks.field_150355_j).func_222380_e()).properties(p -> {
            FluidAttributes attrs = this.attributes.get().build((Fluid)Fluids.field_204546_a);
            return p.func_200951_a(attrs.getLuminosity());
        }).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    public FluidBuilder<T, P> defaultBucket() {
        return (FluidBuilder)this.bucket().build();
    }

    public ItemBuilder<BucketItem, FluidBuilder<T, P>> bucket() {
        return this.bucket(BucketItem::new);
    }

    public <I extends BucketItem> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<Supplier<? extends ForgeFlowingFluid>, Item.Properties, ? extends I> factory) {
        NonNullLazyValue<? extends ForgeFlowingFluid> source = this.source;
        return this.getOwner().item(this, this.bucketName, p -> (BucketItem)factory.apply((Supplier<? extends ForgeFlowingFluid>)source, (Item.Properties)p)).model((ctx, prov) -> prov.generated(ctx::getEntry, new ResourceLocation(this.getOwner().getModid(), "item/" + this.bucketName)));
    }

    @SafeVarargs
    public final FluidBuilder<T, P> tag(Tag<Fluid> ... tags) {
        FluidBuilder ret = (FluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryType(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(prov::func_200426_a).forEach(p -> p.func_200048_a((Object)this.getSource())));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    private ForgeFlowingFluid getSource() {
        NonNullLazyValue<? extends ForgeFlowingFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return source.get();
    }

    private ForgeFlowingFluid.Properties makeProperties() {
        FluidAttributes.Builder attributes = this.attributes.get();
        this.attributesCallback.accept(attributes);
        ForgeFlowingFluid.Properties ret = new ForgeFlowingFluid.Properties(this.source, this.asSupplier(), attributes);
        this.properties.accept(ret);
        return ret;
    }

    @Override
    protected T createEntry() {
        return (T)((ForgeFlowingFluid)this.factory.apply(this.makeProperties()));
    }

    @Override
    public RegistryEntry<T> register() {
        NonNullLazyValue<? extends ForgeFlowingFluid> source = this.source;
        if (source != null) {
            this.getCallback().accept(this.sourceName, Fluid.class, this, source);
        }
        return super.register();
    }

    private static class Builder
    extends FluidAttributes.Builder {
        protected Builder(ResourceLocation still, ResourceLocation flowing, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
            super(still, flowing, attributesFactory);
        }
    }
}

