/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.setup;

import epicsquid.mysticalworld.api.IPlayerShoulderCapability;
import epicsquid.mysticalworld.capability.AnimalCooldownCapability;
import epicsquid.mysticalworld.capability.AnimalCooldownCapabilityStorage;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityStorage;
import epicsquid.mysticalworld.events.CapabilityHandler;
import epicsquid.mysticalworld.events.DamageHandler;
import epicsquid.mysticalworld.events.EntityHandler;
import epicsquid.mysticalworld.events.LootHandler;
import epicsquid.mysticalworld.init.ModCompost;
import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModFeatures;
import epicsquid.mysticalworld.network.Networking;
import epicsquid.mysticalworld.potions.PotionRecipes;
import epicsquid.mysticalworld.setup.ClientSetup;
import epicsquid.mysticalworld.setup.ModifyLoot;
import epicsquid.mysticalworld.world.OreGen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import noobanidus.libs.repack_mysticalworld.noobutil.setup.ShadedCommonSetup;

public class ModSetup {
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ModCompost.init();
            ModEntities.registerEntities();
            Networking.INSTANCE.registerMessages();
            CapabilityManager.INSTANCE.register(AnimalCooldownCapability.class, (Capability.IStorage)new AnimalCooldownCapabilityStorage(), AnimalCooldownCapability::new);
            CapabilityManager.INSTANCE.register(IPlayerShoulderCapability.class, (Capability.IStorage)new PlayerShoulderCapabilityStorage(), PlayerShoulderCapability::new);
            ShadedCommonSetup.init(event);
            OreGen.registerOreGeneration();
            PotionRecipes.registerRecipes();
        });
    }

    public void serverStarting(FMLServerStartedEvent event) {
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        ModifyLoot.modify();
    }

    public void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(DamageHandler::onAttackDamage);
        MinecraftForge.EVENT_BUS.addListener(EntityHandler::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, LootHandler::onLootLoad);
        MinecraftForge.EVENT_BUS.addListener(LootHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::onSquidMilked);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::onPlayerJoin);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::registerListeners);
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        ModFeatures.loadComplete();
    }
}

