/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.Copyable;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class Frequency
implements Copyable<Frequency> {
    public EnumColour left;
    public EnumColour middle;
    public EnumColour right;
    public UUID owner;
    public ITextComponent ownerName;

    public Frequency() {
        this(EnumColour.WHITE, EnumColour.WHITE, EnumColour.WHITE);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, null, null);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right, UUID owner, ITextComponent ownerName) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.owner = owner;
        this.ownerName = ownerName;
    }

    public Frequency(CompoundNBT tagCompound) {
        this.read_internal(tagCompound);
    }

    public static Frequency fromString(String left, String middle, String right) {
        return Frequency.fromString(left, middle, right, null, null);
    }

    public static Frequency fromString(String left, String middle, String right, UUID owner, ITextComponent ownerName) {
        EnumColour c1 = EnumColour.fromName((String)left);
        EnumColour c2 = EnumColour.fromName((String)middle);
        EnumColour c3 = EnumColour.fromName((String)right);
        if (c1 == null) {
            throw new RuntimeException(left + " is an invalid colour!");
        }
        if (c2 == null) {
            throw new RuntimeException(middle + " is an invalid colour!");
        }
        if (c3 == null) {
            throw new RuntimeException(right + " is an invalid colour!");
        }
        return new Frequency(c1, c2, c3, owner, ownerName);
    }

    public Frequency setLeft(EnumColour left) {
        if (left != null) {
            this.left = left;
        }
        return this;
    }

    public Frequency setMiddle(EnumColour middle) {
        if (middle != null) {
            this.middle = middle;
        }
        return this;
    }

    public Frequency setRight(EnumColour right) {
        if (right != null) {
            this.right = right;
        }
        return this;
    }

    public Frequency setOwner(UUID owner) {
        this.owner = owner;
        return this;
    }

    public Frequency setOwnerName(ITextComponent ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public boolean hasOwner() {
        return this.owner != null && this.ownerName != null;
    }

    public Frequency set(EnumColour[] colours) {
        this.setLeft(colours[0]);
        this.setMiddle(colours[1]);
        this.setRight(colours[2]);
        return this;
    }

    public Frequency set(Frequency frequency) {
        this.setLeft(frequency.left);
        this.setMiddle(frequency.middle);
        this.setRight(frequency.right);
        this.setOwner(frequency.owner);
        this.setOwnerName(frequency.ownerName);
        return this;
    }

    public EnumColour getLeft() {
        return this.left;
    }

    public EnumColour getMiddle() {
        return this.middle;
    }

    public EnumColour getRight() {
        return this.right;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public ITextComponent getOwnerName() {
        return this.ownerName;
    }

    public EnumColour[] toArray() {
        return new EnumColour[]{this.left, this.middle, this.right};
    }

    protected Frequency read_internal(CompoundNBT tagCompound) {
        this.left = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("left"));
        this.middle = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("middle"));
        this.right = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("right"));
        if (tagCompound.func_186855_b("owner")) {
            this.owner = tagCompound.func_186857_a("owner");
        }
        if (tagCompound.func_74764_b("owner_name")) {
            this.ownerName = ITextComponent.Serializer.func_150699_a((String)tagCompound.func_74779_i("owner_name"));
        }
        return this;
    }

    protected CompoundNBT write_internal(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("left", this.left.getWoolMeta());
        tagCompound.func_74768_a("middle", this.middle.getWoolMeta());
        tagCompound.func_74768_a("right", this.right.getWoolMeta());
        if (this.owner != null) {
            tagCompound.func_186854_a("owner", this.owner);
        }
        if (this.ownerName != null) {
            tagCompound.func_74778_a("owner_name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.ownerName));
        }
        return tagCompound;
    }

    public CompoundNBT writeToNBT(CompoundNBT tagCompound) {
        this.write_internal(tagCompound);
        return tagCompound;
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeCompoundNBT(this.write_internal(new CompoundNBT()));
    }

    public static Frequency readFromPacket(MCDataInput packet) {
        return new Frequency(packet.readCompoundNBT());
    }

    public static Frequency readFromStack(ItemStack stack) {
        CompoundNBT stackTag;
        if (stack.func_77942_o() && (stackTag = stack.func_77978_p()).func_74764_b("Frequency")) {
            return new Frequency(stackTag.func_74775_l("Frequency"));
        }
        return new Frequency();
    }

    public ItemStack writeToStack(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_218657_a("Frequency", (INBT)this.write_internal(new CompoundNBT()));
        return stack;
    }

    public String toModelLoc() {
        return "left=" + this.getLeft().func_176610_l() + ",middle=" + this.getMiddle().func_176610_l() + ",right=" + this.getRight().func_176610_l() + ",owned=" + this.hasOwner();
    }

    public String toString() {
        String owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + this.owner;
        }
        return "left=" + this.getLeft().func_176610_l() + ",middle=" + this.getMiddle().func_176610_l() + ",right=" + this.getRight().func_176610_l() + owner;
    }

    public ITextComponent getTooltip() {
        return new TranslationTextComponent(this.getLeft().getUnlocalizedName(), new Object[0]).func_150258_a("/").func_150257_a((ITextComponent)new TranslationTextComponent(this.getMiddle().getUnlocalizedName(), new Object[0])).func_150258_a("/").func_150257_a((ITextComponent)new TranslationTextComponent(this.getRight().getUnlocalizedName(), new Object[0]));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Frequency copy() {
        return new Frequency(this.left, this.middle, this.right, this.owner, this.ownerName);
    }
}

