/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.ModContent;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CreateRecipe
extends RecipeBase {
    public CreateRecipe(ResourceLocation id, String group, @Nonnull ItemStack result, NonNullList<Ingredient> input) {
        super(id, group, result, input);
    }

    @Override
    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        EnumColour colour = EnumColour.WHITE;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                EnumColour c;
                ItemStack stack = inv.func_70301_a(x + y * inv.func_174922_i());
                if (stack.func_190926_b() || (c = EnumColour.fromWoolStack((ItemStack)stack)) == null) continue;
                colour = c;
                break block0;
            }
        }
        Frequency frequency = new Frequency(colour, colour, colour);
        return frequency.writeToStack(super.getCraftingResult(inv));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModContent.createRecipeSerializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CreateRecipe> {
        public CreateRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map key = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.func_194134_a((String[])ShapedRecipe.func_192407_a((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.func_192402_a((String[])pattern, (Map)key, (int)width, (int)height);
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new CreateRecipe(recipeId, group, result, (NonNullList<Ingredient>)ingredients);
        }

        @Nullable
        public CreateRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new CreateRecipe(recipeId, s, result, (NonNullList<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, CreateRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            for (Ingredient ingredient : recipe.input) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

