/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config;

import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class InvConfig {
    public ForgeConfigSpec clientSpec;
    private final Client client;

    public InvConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        this.clientSpec = (ForgeConfigSpec)specPair.getRight();
        this.client = (Client)specPair.getLeft();
    }

    public Client getClient() {
        return this.client;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
    }

    public void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, this.clientSpec);
    }

    public static enum ArmorView {
        PERCENTAGE,
        DAMAGE,
        DAMAGE_LEFT;

    }

    public static enum ArmorType {
        ARMOR,
        FULL,
        FULL_AND_INV;

    }

    public static class Client {
        public final ForgeConfigSpec.IntValue xPos;
        public final ForgeConfigSpec.IntValue yPos;
        public final ForgeConfigSpec.BooleanValue byDefault;
        public final ForgeConfigSpec.BooleanValue ArmorDamage;
        public final ForgeConfigSpec.BooleanValue Potions;
        public final ForgeConfigSpec.IntValue xPotionPos;
        public final ForgeConfigSpec.IntValue yPotionPos;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.VAlign> invValign;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.HAlign> invHalign;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.VAlign> potValign;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.HAlign> potHalign;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.VAlign> armValign;
        public final ForgeConfigSpec.EnumValue<WidgetAligns.HAlign> armHalign;
        public final ForgeConfigSpec.EnumValue<ArmorType> armType;
        public final ForgeConfigSpec.EnumValue<ArmorView> armView;
        public final ForgeConfigSpec.IntValue xArmPos;
        public final ForgeConfigSpec.IntValue yArmPos;
        public final ForgeConfigSpec.IntValue armAbove;
        public final ForgeConfigSpec.IntValue potAlpha;
        public final ForgeConfigSpec.IntValue potGap;
        public final ForgeConfigSpec.BooleanValue invMini;
        public final ForgeConfigSpec.BooleanValue invVert;
        public final ForgeConfigSpec.BooleanValue potMini;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for Inventory HUD").push("inventoryhud");
            this.invValign = builder.comment("Inventory HUD vertical align").translation("inventoryhud.config.client.invval").defineEnum("invValign", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.invHalign = builder.comment("Inventory HUD horizontal align").translation("inventoryhud.config.client.invhal").defineEnum("invHalign", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.xPos = builder.comment("Inventory HUD position (X)").translation("inventoryhud.config.client.cx").defineInRange("xPos", 0, -9999, 9999);
            this.yPos = builder.comment("Inventory HUD position (Y)").translation("inventoryhud.config.client.cy").defineInRange("yPos", 150, -9999, 9999);
            this.invMini = builder.comment("Inventory HUD mini mode").translation("inventoryhud.config.client.invmini").define("invMini", false);
            this.invVert = builder.comment("Inventory HUD vertical mode").translation("inventoryhud.config.client.invvert").define("invVert", false);
            this.byDefault = builder.comment("Toggle on by default").translation("inventoryhud.config.client.bydefault").define("byDefault", true);
            builder.pop();
            builder.comment("Settings for ArmorStatus HUD").push("armorhud");
            this.ArmorDamage = builder.comment("Is Armor Damage HUD enabled").translation("inventoryhud.config.client.armordamage").define("ArmorDamage", true);
            this.armValign = builder.comment("Armor HUD vertical align").translation("inventoryhud.config.client.armval").defineEnum("armValign", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.armHalign = builder.comment("Armor HUD horizontal align").translation("inventoryhud.config.client.armhal").defineEnum("armHalign", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.xArmPos = builder.comment("Armor HUD position (X)").translation("inventoryhud.config.client.armx").defineInRange("xArmPos", 0, -9999, 9999);
            this.yArmPos = builder.comment("Armor HUD position (Y)").translation("inventoryhud.config.client.army").defineInRange("yArmPos", 70, -9999, 9999);
            this.armAbove = builder.comment("Hide if durability is above this (in percentage):").translation("inventoryhud.config.client.armabove").defineInRange("armAbove", 100, 0, 100);
            this.armType = builder.comment("Armor HUD type (ARMOR, FULL, FULL and empty inventory slots)").translation("inventoryhud.config.client.armtype").defineEnum("armType", (Enum)ArmorType.FULL_AND_INV);
            this.armView = builder.comment("Armor HUD durability view (PERCENTAGE, DAMAGE, DAMAGE LEFT)").translation("inventoryhud.config.client.armview").defineEnum("armView", (Enum)ArmorView.PERCENTAGE);
            builder.pop();
            builder.comment("Settings for Potions HUD").push("potionshud");
            this.Potions = builder.comment("Is Potions HUD enabled").translation("inventoryhud.config.client.potions").define("Potions", true);
            this.potValign = builder.comment("Potion HUD vertical align").translation("inventoryhud.config.client.potval").defineEnum("potValign", (Enum)WidgetAligns.VAlign.TOP);
            this.potHalign = builder.comment("Potion HUD horizontal align").translation("inventoryhud.config.client.pothal").defineEnum("potHalign", (Enum)WidgetAligns.HAlign.LEFT);
            this.xPotionPos = builder.comment("Potion HUD position (X)").translation("inventoryhud.config.client.potionsx").defineInRange("xPotionPos", 20, -9999, 9999);
            this.yPotionPos = builder.comment("Potion HUD position (Y)").translation("inventoryhud.config.client.potionsy").defineInRange("yPotionPos", 20, -9999, 9999);
            this.potAlpha = builder.comment("Potion HUD alpha").translation("inventoryhud.config.client.potalpha").defineInRange("potAlpha", 100, 0, 100);
            this.potGap = builder.comment("Potion HUD gap").translation("inventoryhud.config.client.potgap").defineInRange("potGap", 0, -5, 5);
            this.potMini = builder.comment("Potion HUD mini mode").translation("inventoryhud.config.client.potmini").define("potMini", false);
            builder.pop();
        }
    }
}

