/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InGameConfigScreen;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigOptionList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;

public class ConfigGui
extends Screen {
    private Button nextMenu;
    private Button prevMenu;
    private MenuType curMenu = MenuType.INV;
    private Button InvOr;
    private Button byDefaultBtn;
    private Button invMini;
    private Button invVert;
    private Button ArmorDamage;
    private Button ArmOr;
    private Button ArmType;
    private Button ArmView;
    private Button PotionHUD;
    private Button PotionOr;
    private Button PotionMini;
    private Integer lastArmAbove;
    private Integer lastPotAlp;
    private Integer lastPotGap;
    private TextFieldWidget armAbove;
    private TextFieldWidget potAlpha;
    private TextFieldWidget potGap;
    private ConfigOptionList optionList;
    private boolean inGame = false;

    public ConfigGui(int menu, boolean inGame) {
        super((ITextComponent)new TranslationTextComponent("Inventory HUD+ Config", new Object[0]));
        switch (menu) {
            case 0: {
                this.curMenu = MenuType.INV;
                break;
            }
            case 1: {
                this.curMenu = MenuType.ARM;
                break;
            }
            case 2: {
                this.curMenu = MenuType.POT;
            }
        }
        this.inGame = inGame;
    }

    protected void init() {
        this.optionList = new ConfigOptionList(this.minecraft, this);
        this.nextMenu = new Button(this.width / 2 + 75, 10, 20, 20, ">", btn -> this.ChangeMenu(true));
        this.prevMenu = new Button(this.width / 2 - 95, 10, 20, 20, "<", btn -> this.ChangeMenu(false));
        this.InvOr = new Button(this.width / 2 - 60, 160, 120, 20, "Change position", btn -> Minecraft.func_71410_x().func_147108_a((Screen)new InGameConfigScreen(0, this.inGame)));
        this.byDefaultBtn = new Button(this.width / 2 + 20, 50, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().byDefault.get()).toString(), btn -> this.ChangeByDefault());
        this.invMini = new Button(this.width / 2 + 20, 110, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().invMini.get()).toString(), btn -> this.ChangeInvMini());
        this.invVert = new Button(this.width / 2 + 20, 80, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().invVert.get()).toString(), btn -> this.ChangeInvVert());
        String potString = "";
        potString = (Boolean)InventoryHUD.getConfig().getClient().Potions.get() != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.PotionHUD = new Button(this.width / 2 + 20, 50, 40, 20, potString, btn -> this.ChangePotion());
        this.PotionOr = new Button(this.width / 2 - 60, 190, 120, 20, "Change position", btn -> Minecraft.func_71410_x().func_147108_a((Screen)new InGameConfigScreen(2, this.inGame)));
        String potal = "" + InventoryHUD.getConfig().getClient().potAlpha.get();
        try {
            this.lastPotAlp = Integer.valueOf(potal);
        }
        catch (Exception e) {
            this.lastPotAlp = 100;
        }
        this.potAlpha = new TextFieldWidget(this.font, this.width / 2 + 20, 80, 40, 20, potal);
        String potg = "" + InventoryHUD.getConfig().getClient().potGap.get();
        try {
            this.lastPotGap = Integer.valueOf(potg);
        }
        catch (Exception e) {
            this.lastPotGap = 0;
        }
        this.PotionMini = new Button(this.width / 2 + 20, 110, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().potMini.get()).toString(), btn -> this.ChangePotMini());
        this.potGap = new TextFieldWidget(this.font, this.width / 2 + 20, 140, 40, 20, potg);
        String armString = "";
        armString = (Boolean)InventoryHUD.getConfig().getClient().ArmorDamage.get() != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ArmorDamage = new Button(this.width / 2 + 20, 50, 40, 20, armString, btn -> this.ChangeArmor());
        this.ArmOr = new Button(this.width / 2 - 60, 160, 120, 20, "Change position", btn -> Minecraft.func_71410_x().func_147108_a((Screen)new InGameConfigScreen(1, this.inGame)));
        String aaS = "" + InventoryHUD.getConfig().getClient().armAbove.get();
        try {
            this.lastArmAbove = Integer.valueOf(aaS);
        }
        catch (NumberFormatException ex) {
            this.lastArmAbove = 100;
        }
        this.armAbove = new TextFieldWidget(this.font, this.width / 2 + 20, 80, 40, 20, aaS);
        this.ArmType = new Button(this.width / 2 + 20, 110, 75, 20, ((InvConfig.ArmorType)((Object)InventoryHUD.getConfig().getClient().armType.get())).name(), btn -> this.ChangeArmType());
        this.ArmView = new Button(this.width / 2 + 100, 110, 75, 20, ((InvConfig.ArmorView)((Object)InventoryHUD.getConfig().getClient().armView.get())).name(), btn -> this.ChangeArmView());
        this.children.add(this.nextMenu);
        this.children.add(this.prevMenu);
        this.children.add(this.InvOr);
        this.children.add(this.byDefaultBtn);
        this.children.add(this.invMini);
        this.children.add(this.invVert);
        this.children.add(this.PotionHUD);
        this.children.add(this.PotionOr);
        this.children.add(this.potAlpha);
        this.children.add(this.PotionMini);
        this.children.add(this.potGap);
        this.children.add(this.ArmorDamage);
        this.children.add(this.ArmOr);
        this.children.add(this.armAbove);
        this.children.add(this.ArmType);
        this.children.add(this.ArmView);
        this.nextMenu.active = true;
        this.prevMenu.active = true;
        this.potAlpha.func_146203_f(4);
        this.potAlpha.func_146191_b(potal);
        this.potGap.func_146203_f(3);
        this.potGap.func_146191_b(potg);
        this.armAbove.func_146203_f(4);
        this.armAbove.func_146191_b(aaS);
        this.DisableAll();
        switch (this.curMenu) {
            case INV: {
                this.EnableInv();
                break;
            }
            case ARM: {
                this.EnableArm();
                break;
            }
            case POT: {
                this.EnablePot();
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        this.optionList.render(mouseX, mouseY, partialTick);
        this.nextMenu.render(mouseX, mouseY, partialTick);
        this.prevMenu.render(mouseX, mouseY, partialTick);
        String MenuString = "";
        switch (this.curMenu) {
            case INV: {
                this.InvOr.render(mouseX, mouseY, partialTick);
                this.byDefaultBtn.render(mouseX, mouseY, partialTick);
                this.invMini.render(mouseX, mouseY, partialTick);
                this.invVert.render(mouseX, mouseY, partialTick);
                this.drawRightAlignedString(this.font, "Toggle on by default", this.width / 2 - 20, 57, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Potion HUD vertical mode", this.width / 2 - 20, 87, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Potion HUD mini mode", this.width / 2 - 20, 117, 0xFFFFFF);
                MenuString = "Inventory HUD options";
                break;
            }
            case ARM: {
                this.ArmorDamage.render(mouseX, mouseY, partialTick);
                this.ArmOr.render(mouseX, mouseY, partialTick);
                this.armAbove.render(mouseX, mouseX, partialTick);
                this.ArmType.render(mouseX, mouseY, partialTick);
                this.ArmView.render(mouseX, mouseY, partialTick);
                this.drawRightAlignedString(this.font, "Toggle On/Off Armor HUD", this.width / 2 - 20, 57, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "ArmorStatus HUD Types:", this.width / 2 - 20, 117, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Hide armor if durability above (in percentage):", this.width / 2 - 20, 87, 0xFFFFFF);
                MenuString = "ArmorStatus HUD options";
                break;
            }
            case POT: {
                this.PotionHUD.render(mouseX, mouseY, partialTick);
                this.PotionOr.render(mouseX, mouseY, partialTick);
                this.potAlpha.render(mouseX, mouseY, partialTick);
                this.PotionMini.render(mouseX, mouseY, partialTick);
                this.potGap.render(mouseX, mouseY, partialTick);
                this.drawRightAlignedString(this.font, "Toggle On/Off Potions HUD", this.width / 2 - 20, 57, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Potion HUD alpha", this.width / 2 - 20, 87, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Potion HUD mini mode", this.width / 2 - 20, 117, 0xFFFFFF);
                this.drawRightAlignedString(this.font, "Potion HUD gap", this.width / 2 - 20, 147, 0xFFFFFF);
                MenuString = "Potion HUD options";
            }
        }
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        this.drawCenteredString(this.font, MenuString, this.width / 2, 27, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTick);
    }

    private void DisableAll() {
        this.byDefaultBtn.active = false;
        this.InvOr.active = false;
        this.invMini.active = false;
        this.invVert.active = false;
        this.ArmorDamage.active = false;
        this.ArmOr.active = false;
        this.ArmType.active = false;
        this.ArmView.active = false;
        this.armAbove.func_146189_e(false);
        this.armAbove.func_146184_c(false);
        this.armAbove.active = false;
        this.PotionHUD.active = false;
        this.PotionOr.active = false;
        this.potAlpha.func_146189_e(false);
        this.potAlpha.func_146184_c(false);
        this.potAlpha.active = false;
        this.PotionMini.active = false;
        this.potGap.func_146189_e(false);
        this.potGap.func_146184_c(false);
    }

    private void EnableInv() {
        this.byDefaultBtn.active = true;
        this.InvOr.active = true;
        this.invMini.active = true;
        this.invVert.active = true;
    }

    private void EnableArm() {
        this.ArmorDamage.active = true;
        this.ArmOr.active = true;
        this.ArmType.active = true;
        this.ArmView.active = true;
        this.armAbove.active = true;
        this.armAbove.func_146189_e(true);
        this.armAbove.func_146184_c(true);
    }

    private void EnablePot() {
        this.PotionHUD.active = true;
        this.PotionOr.active = true;
        this.potAlpha.active = true;
        this.PotionMini.active = true;
        this.potAlpha.func_146189_e(true);
        this.potAlpha.func_146184_c(true);
        this.potGap.func_146189_e(true);
        this.potGap.func_146184_c(true);
    }

    private void ChangeMenu(boolean next) {
        this.DisableAll();
        if (next) {
            switch (this.curMenu) {
                case INV: {
                    this.EnableArm();
                    this.curMenu = MenuType.ARM;
                    break;
                }
                case ARM: {
                    this.EnablePot();
                    this.curMenu = MenuType.POT;
                    break;
                }
                case POT: {
                    this.EnableInv();
                    this.curMenu = MenuType.INV;
                }
            }
        } else {
            switch (this.curMenu) {
                case INV: {
                    this.EnablePot();
                    this.curMenu = MenuType.POT;
                    break;
                }
                case ARM: {
                    this.EnableInv();
                    this.curMenu = MenuType.INV;
                    break;
                }
                case POT: {
                    this.EnableArm();
                    this.curMenu = MenuType.ARM;
                }
            }
        }
    }

    private void ChangeInvMini() {
        Boolean mm = (Boolean)InventoryHUD.getConfig().getClient().invMini.get() == false;
        InventoryGui.invMini = mm;
        InventoryHUD.getConfig().getClient().invMini.set((Object)mm);
        this.invMini.setMessage(mm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangeInvVert() {
        Boolean vm = (Boolean)InventoryHUD.getConfig().getClient().invVert.get() == false;
        InventoryGui.invVert = vm;
        InventoryHUD.getConfig().getClient().invVert.set((Object)vm);
        this.invVert.setMessage(vm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangeByDefault() {
        Boolean bd = (Boolean)InventoryHUD.getConfig().getClient().byDefault.get() == false;
        InventoryHUD.isActive = bd;
        InventoryHUD.getConfig().getClient().byDefault.set((Object)bd);
        this.byDefaultBtn.setMessage(bd.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangeArmView() {
        InvConfig.ArmorView at = (InvConfig.ArmorView)((Object)InventoryHUD.getConfig().getClient().armView.get());
        switch (at) {
            case PERCENTAGE: {
                at = InvConfig.ArmorView.DAMAGE;
                break;
            }
            case DAMAGE: {
                at = InvConfig.ArmorView.DAMAGE_LEFT;
                break;
            }
            case DAMAGE_LEFT: {
                at = InvConfig.ArmorView.PERCENTAGE;
            }
        }
        InventoryGui.armView = at;
        InventoryHUD.getConfig().getClient().armView.set((Object)at);
        this.ArmView.setMessage(at.name());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangeArmType() {
        InvConfig.ArmorType at = (InvConfig.ArmorType)((Object)InventoryHUD.getConfig().getClient().armType.get());
        switch (at) {
            case ARMOR: {
                at = InvConfig.ArmorType.FULL;
                break;
            }
            case FULL: {
                at = InvConfig.ArmorType.FULL_AND_INV;
                break;
            }
            case FULL_AND_INV: {
                at = InvConfig.ArmorType.ARMOR;
            }
        }
        InventoryGui.armType = at;
        InventoryHUD.getConfig().getClient().armType.set((Object)at);
        this.ArmType.setMessage(at.name());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangeArmor() {
        Boolean armor = (Boolean)InventoryHUD.getConfig().getClient().ArmorDamage.get() == false;
        InventoryHUD.armorHUD = armor;
        InventoryHUD.getConfig().getClient().ArmorDamage.set((Object)armor);
        String armString = "";
        armString = armor != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ArmorDamage.setMessage(armString);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangePotion() {
        Boolean potion = (Boolean)InventoryHUD.getConfig().getClient().Potions.get() == false;
        InventoryHUD.potionHUD = potion;
        InventoryHUD.getConfig().getClient().Potions.set((Object)potion);
        String potString = "";
        potString = potion != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.PotionHUD.setMessage(potString);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ChangePotMini() {
        Boolean mini = (Boolean)InventoryHUD.getConfig().getClient().potMini.get() == false;
        InventoryGui.potMini = mini;
        InventoryHUD.getConfig().getClient().potMini.set((Object)mini);
        this.PotionMini.setMessage(mini.toString());
        InventoryHUD.getConfig().clientSpec.save();
        InventoryGui.PotPosChanged();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.potGap.visible) {
            this.potGap.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        if (this.potAlpha.visible) {
            this.potAlpha.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        if (this.armAbove.visible) {
            this.armAbove.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        super.tick();
        switch (1.$SwitchMap$dlovin$inventoryhud$gui$ConfigGui$MenuType[this.curMenu.ordinal()]) {
            case 1: {
                break;
            }
            case 3: {
                if (!this.potAlpha.isFocused()) ** GOTO lbl22
                try {
                    a = Integer.valueOf(this.potAlpha.func_146179_b());
                    if (a < 0 || a > 100) ** GOTO lbl17
                    this.potAlpha.func_146193_g(-1);
                    if (this.lastPotAlp != a) {
                        this.lastPotAlp = a;
                        InventoryGui.potAlpha = (float)a / 100.0f;
                        InventoryHUD.getConfig().getClient().potAlpha.set((Object)a);
                        InventoryHUD.getConfig().clientSpec.save();
                    }
                    ** GOTO lbl25
lbl17:
                    // 1 sources

                    this.potAlpha.func_146193_g(-65536);
                }
                catch (NumberFormatException ex) {
                    this.potAlpha.func_146193_g(-65536);
                }
                ** GOTO lbl25
lbl22:
                // 1 sources

                this.potAlpha.func_146193_g(-1);
                if (this.lastPotAlp.toString() != this.potAlpha.func_146179_b()) {
                    this.potAlpha.func_146180_a(this.lastPotAlp.toString());
                }
lbl25:
                // 6 sources

                if (this.potGap.isFocused()) {
                    try {
                        a = Integer.valueOf(this.potGap.func_146179_b());
                        if (a >= -5 && a <= 5) {
                            this.potGap.func_146193_g(-1);
                            if (this.lastPotGap == a) break;
                            this.lastPotGap = a;
                            InventoryGui.potGap = a;
                            InventoryHUD.getConfig().getClient().potGap.set((Object)a);
                            InventoryHUD.getConfig().clientSpec.save();
                            break;
                        }
                        this.potGap.func_146193_g(-65536);
                    }
                    catch (NumberFormatException ex) {
                        this.potGap.func_146193_g(-65536);
                    }
                    break;
                }
                this.potGap.func_146193_g(-1);
                if (this.lastPotGap.toString() == this.potGap.func_146179_b()) break;
                this.potGap.func_146180_a(this.lastPotGap.toString());
                break;
            }
            case 2: {
                if (this.armAbove.isFocused()) {
                    try {
                        a = Integer.valueOf(this.armAbove.func_146179_b());
                        if (a >= 0 && a <= 100) {
                            this.armAbove.func_146193_g(-1);
                            if (this.lastArmAbove == a) break;
                            this.lastArmAbove = a;
                            InventoryGui.armAbove = a;
                            InventoryHUD.getConfig().getClient().armAbove.set((Object)a);
                            InventoryHUD.getConfig().clientSpec.save();
                            break;
                        }
                        this.armAbove.func_146193_g(-65536);
                    }
                    catch (NumberFormatException ex) {
                        this.armAbove.func_146193_g(-65536);
                    }
                    break;
                }
                this.armAbove.func_146193_g(-1);
                if (this.lastArmAbove.toString() == this.armAbove.func_146179_b()) break;
                this.armAbove.func_146180_a(this.lastArmAbove.toString());
            }
        }
    }

    public void onClose() {
        if (this.inGame) {
            this.minecraft.func_147108_a(null);
        } else {
            this.minecraft.func_147108_a((Screen)new ModListScreen(null));
        }
    }

    private static enum MenuType {
        INV,
        POT,
        ARM;

    }
}

