/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.ConfigGui;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InGameConfigScreen
extends Screen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private Button backButton;
    private int menu = -1;
    private boolean inGame = false;

    public InGameConfigScreen(int menu, boolean inGame) {
        super((ITextComponent)new TranslationTextComponent("InventoryHUD Config Screen", new Object[0]));
        this.menu = menu;
        this.inGame = inGame;
    }

    protected void init() {
        int x = 0;
        int y = 0;
        float invScale = (Boolean)InventoryHUD.getConfig().getClient().invMini.get() != false ? 0.75f : 1.0f;
        int invWidth = (Boolean)InventoryHUD.getConfig().getClient().invVert.get() != false ? 54 : 162;
        int invHeight = (Boolean)InventoryHUD.getConfig().getClient().invVert.get() != false ? 162 : 54;
        switch (InventoryGui.InvAligns.HorAlign) {
            case LEFT: {
                x = InventoryGui.invX;
                break;
            }
            case MIDDLE: {
                x = (int)((float)(this.width / 2) - (float)invWidth * invScale / 2.0f - (float)InventoryGui.invX);
                break;
            }
            case RIGHT: {
                x = this.width - InventoryGui.invX;
            }
        }
        switch (InventoryGui.InvAligns.VertAlign) {
            case TOP: {
                y = InventoryGui.invY;
                break;
            }
            case CENTER: {
                y = (int)((float)(this.height / 2) - (float)invHeight * invScale / 2.0f - (float)InventoryGui.invY);
                break;
            }
            case BOTTOM: {
                y = this.height - InventoryGui.invY;
            }
        }
        if (x < 0) {
            x = 0;
        } else if ((float)x > (float)this.width - (float)invWidth * invScale) {
            x = (int)((float)this.width - (float)invWidth * invScale);
        }
        if (y < 0) {
            y = 0;
        } else if ((float)y > (float)this.height - (float)invHeight * invScale) {
            y = (int)((float)this.height - (float)invHeight * invScale);
        }
        this.backButton = new Button(this.width - 60, 10, 50, 20, "Back", btn -> this.onClose());
        this.ICW = new ConfigWidget(x, y, invWidth, invHeight, invScale, "Inventory", InventoryHUD.isActive);
        if (!((Boolean)InventoryHUD.getConfig().getClient().invVert.get()).booleanValue()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(() -> this.onInvChanged());
        this.ICW.addPosListener(() -> this.onInvPosChanged());
        float potScale = (Boolean)InventoryHUD.getConfig().getClient().potMini.get() != false ? 0.75f : 1.0f;
        switch (InventoryGui.PotAligns.HorAlign) {
            case LEFT: {
                x = InventoryGui.potX;
                break;
            }
            case MIDDLE: {
                x = (int)((float)(this.width / 2) - 30.0f * potScale - (float)InventoryGui.potX);
                break;
            }
            case RIGHT: {
                x = this.width - InventoryGui.potX;
            }
        }
        switch (InventoryGui.PotAligns.VertAlign) {
            case TOP: {
                y = InventoryGui.potY;
                break;
            }
            case CENTER: {
                y = (int)((float)(this.height / 2) - 12.0f * potScale - (float)InventoryGui.potY);
                break;
            }
            case BOTTOM: {
                y = this.height - InventoryGui.potY;
            }
        }
        if (x < 0) {
            x = 0;
        } else if ((float)x > (float)this.width - 60.0f * potScale) {
            x = (int)((float)this.width - 60.0f * potScale);
        }
        if (y < 0) {
            y = 0;
        } else if ((float)y > (float)this.height - 24.0f * potScale) {
            y = (int)((float)this.height - 24.0f * potScale);
        }
        this.PCW = new ConfigWidget(x, y, 60, 24, potScale, "Potions", InventoryHUD.potionHUD);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(() -> this.onPotionChanged());
        this.PCW.addPosListener(() -> this.onPotionPosChanged());
        switch (InventoryGui.ArmAligns.HorAlign) {
            case LEFT: {
                x = InventoryGui.armX;
                break;
            }
            case MIDDLE: {
                x = this.width / 2 - 45 - InventoryGui.armX;
                break;
            }
            case RIGHT: {
                x = this.width - InventoryGui.armX;
            }
        }
        switch (InventoryGui.ArmAligns.VertAlign) {
            case TOP: {
                y = InventoryGui.armY;
                break;
            }
            case CENTER: {
                y = this.height / 2 - 35 - InventoryGui.armY;
                break;
            }
            case BOTTOM: {
                y = this.height - InventoryGui.armY;
            }
        }
        if (x < 0) {
            x = 0;
        } else if (x > this.width - 90) {
            x = this.width - 90;
        }
        if (y < 0) {
            y = 0;
        } else if (y > this.height - 70) {
            y = this.height - 70;
        }
        this.ACW = new ConfigWidget(x, y, 90, 70, 1.0f, "Armor", InventoryHUD.armorHUD);
        this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
        this.ACW.addListener(() -> this.onArmorChanged());
        this.ACW.addPosListener(() -> this.onArmorPosChanged());
        this.children.add(this.backButton);
        this.children.add(this.ICW);
        this.children.add(this.PCW);
        this.children.add(this.ACW);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.CONF_BG);
        InGameConfigScreen.blit((int)0, (int)(this.height / 3 - 1), (float)this.width, (float)3.0f, (int)this.width, (int)3, (int)3, (int)3);
        InGameConfigScreen.blit((int)0, (int)(this.height / 3 * 2 - 1), (float)this.width, (float)3.0f, (int)this.width, (int)3, (int)3, (int)3);
        InGameConfigScreen.blit((int)(this.width / 3 - 1), (int)0, (float)3.0f, (float)this.height, (int)3, (int)this.height, (int)3, (int)3);
        InGameConfigScreen.blit((int)(this.width / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.height, (int)3, (int)this.height, (int)3, (int)3);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        this.ACW.render(mouseX, mouseY, partialTick);
        this.PCW.render(mouseX, mouseY, partialTick);
        this.ICW.render(mouseX, mouseY, partialTick);
        this.backButton.render(mouseX, mouseY, partialTick);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getConfig().getClient().byDefault.set((Object)this.ICW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ICW.x + this.ICW.getWidth() / 2 <= mc.field_71462_r.width / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.x;
        } else if (this.ICW.x + this.ICW.getWidth() / 2 >= mc.field_71462_r.width / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = mc.field_71462_r.width - this.ICW.x;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.x + this.ICW.getWidth() / 2 <= mc.field_71462_r.width / 2 - 10 ? mc.field_71462_r.width / 2 - this.ICW.getWidth() / 2 - this.ICW.x : (this.ICW.x + this.ICW.getWidth() / 2 >= mc.field_71462_r.width / 2 + 10 ? mc.field_71462_r.width / 2 - this.ICW.getWidth() / 2 - this.ICW.x : 0);
        }
        if (this.ICW.y + this.ICW.getHeight() / 2 <= mc.field_71462_r.height / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.y;
        } else if (this.ICW.y + this.ICW.getHeight() / 2 >= mc.field_71462_r.height / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = mc.field_71462_r.height - this.ICW.y;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.y + this.ICW.getHeight() / 2 <= mc.field_71462_r.height / 2 - 10 ? mc.field_71462_r.height / 2 - this.ICW.getHeight() / 2 - this.ICW.y : (this.ICW.y + this.ICW.getHeight() / 2 >= mc.field_71462_r.height / 2 + 10 ? mc.field_71462_r.height / 2 - this.ICW.getHeight() / 2 - this.ICW.y : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getConfig().getClient().Potions.set((Object)this.PCW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.PCW.x + this.PCW.getWidth() / 2 <= mc.field_71462_r.width / 3) {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.potX = this.PCW.x;
            InventoryGui.PotPosChanged();
        } else if (this.PCW.x + this.PCW.getWidth() / 2 >= mc.field_71462_r.width / 3 * 2) {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.potX = mc.field_71462_r.width - this.PCW.x;
            InventoryGui.PotPosChanged();
        } else {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.x + this.PCW.getWidth() / 2 <= mc.field_71462_r.width / 2 - 10) {
                InventoryGui.potX = mc.field_71462_r.width / 2 - this.PCW.getWidth() / 2 - this.PCW.x;
                InventoryGui.PotPosChanged();
            } else if (this.PCW.x + this.PCW.getWidth() / 2 >= mc.field_71462_r.width / 2 + 10) {
                InventoryGui.potX = mc.field_71462_r.width / 2 - this.PCW.getWidth() / 2 - this.PCW.x;
                InventoryGui.PotPosChanged();
            } else {
                InventoryGui.potX = 0;
                InventoryGui.PotPosChanged();
            }
        }
        if (this.PCW.y + this.PCW.getHeight() / 2 <= mc.field_71462_r.height / 3) {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.potY = this.PCW.y;
            InventoryGui.PotPosYChanged(true);
        } else if (this.PCW.y + this.PCW.getHeight() / 2 >= mc.field_71462_r.height / 3 * 2) {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.potY = mc.field_71462_r.height - this.PCW.y;
            InventoryGui.PotPosYChanged(false);
        } else {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.y + this.PCW.getHeight() / 2 <= mc.field_71462_r.height / 2 - 10) {
                InventoryGui.potY = mc.field_71462_r.height / 2 - this.PCW.getHeight() / 2 - this.PCW.y;
                InventoryGui.PotPosYChanged(true);
            } else if (this.PCW.y + this.PCW.getHeight() / 2 >= mc.field_71462_r.height / 2 + 10) {
                InventoryGui.potY = mc.field_71462_r.height / 2 - this.PCW.getHeight() / 2 - this.PCW.y;
                InventoryGui.PotPosYChanged(false);
            } else {
                InventoryGui.potY = 0;
                InventoryGui.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getConfig().getClient().ArmorDamage.set((Object)this.ACW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onArmorPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ACW.x + this.ACW.getWidth() / 2 <= mc.field_71462_r.width / 3) {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.armX = this.ACW.x;
        } else if (this.ACW.x + this.ACW.getWidth() / 2 >= mc.field_71462_r.width / 3 * 2) {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.armX = mc.field_71462_r.width - this.ACW.x;
        } else {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.armX = this.ACW.x + this.ACW.getWidth() / 2 <= mc.field_71462_r.width / 2 - 10 ? mc.field_71462_r.width / 2 - this.ACW.getWidth() / 2 - this.ACW.x : (this.ACW.x + this.ACW.getWidth() / 2 >= mc.field_71462_r.width / 2 + 10 ? mc.field_71462_r.width / 2 - this.ACW.getWidth() / 2 - this.ACW.x : 0);
        }
        if (this.ACW.y + this.ACW.getHeight() / 2 <= mc.field_71462_r.height / 2 - 10) {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.armY = this.ACW.y;
        } else if (this.ACW.y + this.ACW.getHeight() / 2 >= mc.field_71462_r.height / 2 + 10) {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.armY = mc.field_71462_r.height - this.ACW.y;
        } else {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.armY = this.ACW.y + this.ACW.getHeight() / 2 <= mc.field_71462_r.height / 2 - 10 ? mc.field_71462_r.height / 2 - this.ACW.getHeight() / 2 - this.ACW.y : (this.ACW.y + this.ACW.getHeight() / 2 >= mc.field_71462_r.height / 2 + 10 ? mc.field_71462_r.height / 2 - this.ACW.getHeight() / 2 - this.ACW.y : 0);
        }
    }

    private void saveConfig() {
        InventoryHUD.getConfig().getClient().xPos.set((Object)InventoryGui.invX);
        InventoryHUD.getConfig().getClient().yPos.set((Object)InventoryGui.invY);
        InventoryHUD.getConfig().getClient().invHalign.set((Object)InventoryGui.InvAligns.HorAlign);
        InventoryHUD.getConfig().getClient().invValign.set((Object)InventoryGui.InvAligns.VertAlign);
        InventoryHUD.getConfig().getClient().xPotionPos.set((Object)InventoryGui.potX);
        InventoryHUD.getConfig().getClient().yPotionPos.set((Object)InventoryGui.potY);
        InventoryHUD.getConfig().getClient().potHalign.set((Object)InventoryGui.PotAligns.HorAlign);
        InventoryHUD.getConfig().getClient().potValign.set((Object)InventoryGui.PotAligns.VertAlign);
        InventoryHUD.getConfig().getClient().xArmPos.set((Object)InventoryGui.armX);
        InventoryHUD.getConfig().getClient().yArmPos.set((Object)InventoryGui.armY);
        InventoryHUD.getConfig().getClient().armHalign.set((Object)InventoryGui.ArmAligns.HorAlign);
        InventoryHUD.getConfig().getClient().armValign.set((Object)InventoryGui.ArmAligns.VertAlign);
        InventoryHUD.getConfig().clientSpec.save();
    }

    public void onClose() {
        this.saveConfig();
        switch (this.menu) {
            case -1: {
                this.minecraft.func_147108_a((Screen)null);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.minecraft.func_147108_a((Screen)new ConfigGui(this.menu, this.inGame));
            }
        }
    }
}

