/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryGui
extends IngameGui {
    private final ItemRenderer itemRenderer;
    private final FontRenderer fontRenderer;
    private final Minecraft minecraft;
    public static int invX;
    public static int invY;
    public static int potX;
    public static int potY;
    public static int armX;
    public static int armY;
    public static WidgetAligns InvAligns;
    public static WidgetAligns PotAligns;
    public static WidgetAligns ArmAligns;
    public static int potSide;
    public static int potIconSide;
    public static int potTextSide;
    public static int potVert;
    public static int armAbove;
    public static float potAlpha;
    public static boolean potMini;
    public static int potGap;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean invTop;
    public static boolean potTop;
    public static boolean armTop;
    public static InvConfig.ArmorType armType;
    public static InvConfig.ArmorView armView;
    private static final String[] armorRL;
    private final int[][] armorPosX = new int[][]{{-136, -136, 119, 119, 119, -136, 119, -136}, {-119, -119, 94, 94, 94, -119, 94, -138}};
    private final int[] armorPosY = new int[]{-56, -38, -56, -38, -74, -74, -20, -20};
    private static final ResourceLocation PBG;
    private static final ResourceLocation PBGM;
    private static final ResourceLocation PMT;

    public InventoryGui() {
        super(Minecraft.func_71410_x());
        this.minecraft = Minecraft.func_71410_x();
        this.itemRenderer = this.minecraft.func_175599_af();
        this.fontRenderer = this.minecraft.field_71466_p;
        invX = (Integer)InventoryHUD.getConfig().getClient().xPos.get();
        invY = (Integer)InventoryHUD.getConfig().getClient().yPos.get();
        potX = (Integer)InventoryHUD.getConfig().getClient().xPotionPos.get();
        potY = (Integer)InventoryHUD.getConfig().getClient().yPotionPos.get();
        armX = (Integer)InventoryHUD.getConfig().getClient().xArmPos.get();
        armY = (Integer)InventoryHUD.getConfig().getClient().yArmPos.get();
        InvAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getConfig().getClient().invHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getConfig().getClient().invValign.get()));
        PotAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getConfig().getClient().potHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getConfig().getClient().potValign.get()));
        ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getConfig().getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getConfig().getClient().armValign.get()));
        invMini = (Boolean)InventoryHUD.getConfig().getClient().invMini.get();
        invVert = (Boolean)InventoryHUD.getConfig().getClient().invVert.get();
        potMini = (Boolean)InventoryHUD.getConfig().getClient().potMini.get();
        potGap = (Integer)InventoryHUD.getConfig().getClient().potGap.get();
        InventoryGui.PotPosChanged();
        switch (InventoryGui.PotAligns.VertAlign) {
            case TOP: {
                potVert = 1;
                break;
            }
            case CENTER: {
                if (potY - 12 < this.field_73839_d.func_228018_at_().func_198087_p() / 2) {
                    potVert = -1;
                    break;
                }
                potVert = 1;
                break;
            }
            case BOTTOM: {
                potVert = -1;
            }
        }
        armAbove = (Integer)InventoryHUD.getConfig().getClient().armAbove.get();
        potAlpha = (float)((Integer)InventoryHUD.getConfig().getClient().potAlpha.get()).intValue() / 100.0f;
        armType = (InvConfig.ArmorType)((Object)InventoryHUD.getConfig().getClient().armType.get());
        armView = (InvConfig.ArmorView)((Object)InventoryHUD.getConfig().getClient().armView.get());
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && InventoryHUD.potionHUD) {
            event.setCanceled(true);
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        int width = this.field_73839_d.func_228018_at_().func_198107_o();
        int height = this.field_73839_d.func_228018_at_().func_198087_p();
        if (InventoryHUD.armorHUD || InventoryHUD.potionHUD) {
            if (InventoryHUD.armorHUD) {
                this.RenderArmorStatus(width, height);
            }
            if (InventoryHUD.potionHUD) {
                this.RenderPotions(width, height);
            }
        }
        if (!InventoryHUD.isActive) {
            return;
        }
        if (this.field_73839_d.field_71462_r instanceof ContainerScreen) {
            return;
        }
        this.RenderInventory(width, height);
    }

    private void RenderInventory(int width, int height) {
        int px = 0;
        int py = 0;
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        double scale = invMini ? 0.75 : 1.0;
        switch (InventoryGui.InvAligns.HorAlign) {
            case LEFT: {
                px = invX;
                break;
            }
            case MIDDLE: {
                px = (int)((double)(width / 2) - (double)(iMax * 9) * scale - (double)invX);
                break;
            }
            case RIGHT: {
                px = width - invX;
            }
        }
        switch (InventoryGui.InvAligns.VertAlign) {
            case TOP: {
                py = invY;
                break;
            }
            case CENTER: {
                py = (int)((double)(height / 2) - (double)(jMax * 9) * scale - (double)invY);
                break;
            }
            case BOTTOM: {
                py = height - invY;
            }
        }
        if (px < 0) {
            px = 0;
        } else if ((double)px > (double)width - (double)(iMax * 18) * scale) {
            px = (int)((double)width - (double)(iMax * 18) * scale);
        }
        if (py < 0) {
            py = 0;
        } else if ((double)py > (double)height - (double)(jMax * 18) * scale) {
            py = (int)((double)height - (double)(jMax * 18) * scale);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)px, (double)py, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderHelper.func_227780_a_();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.field_73839_d.field_71439_g.field_71071_by.field_70462_a.get(index);
                this.itemRenderer.func_180450_b(item, i * 18, j * 18);
                this.itemRenderer.func_180453_a(this.fontRenderer, item, i * 18, j * 18, null);
            }
        }
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    private boolean isArrow(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ArrowItem;
    }

    private void RenderArmorStatus(int width, int height) {
        if (InventoryGui.ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && InventoryGui.ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90) {
            int i = 5;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)0.0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (ItemStack item : this.field_73839_d.field_71439_g.func_184209_aF()) {
                if (armType == InvConfig.ArmorType.ARMOR && i > 3) {
                    --i;
                    continue;
                }
                int Damage = ArmorStatus.GetDamage(item);
                if (Damage >= 0 && Damage <= armAbove) {
                    String text = "";
                    int xp = width / 2 + this.armorPosX[1][i];
                    switch (armView) {
                        case PERCENTAGE: {
                            String p = String.valueOf(Damage);
                            text = this.getDamageText(p, Damage);
                            switch (i) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    xp += 18 - p.length() * 6;
                                }
                            }
                            break;
                        }
                        case DAMAGE: {
                            String p = String.valueOf(item.func_77952_i());
                            text = this.getDamageText(p, Damage);
                            switch (i) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    xp += 23 - p.length() * 6;
                                }
                            }
                            break;
                        }
                        case DAMAGE_LEFT: {
                            String p = String.valueOf(item.func_77958_k() - item.func_77952_i());
                            text = this.getDamageText(p, Damage);
                            switch (i) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    xp += 23 - p.length() * 6;
                                }
                            }
                            break;
                        }
                    }
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, width / 2 + this.armorPosX[0][i], height + this.armorPosY[i]);
                    RenderHelper.func_74518_a();
                    this.fontRenderer.func_175063_a(text, (float)xp, (float)(height + this.armorPosY[i] + 4), 0xFFFFFF);
                } else if (Damage == -2 && armAbove == 100) {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, width / 2 + this.armorPosX[0][i], height + this.armorPosY[i]);
                    this.itemRenderer.func_180453_a(this.fontRenderer, item, width / 2 + this.armorPosX[0][i], height + this.armorPosY[i], null);
                    RenderHelper.func_74518_a();
                } else {
                    if (i == 5) {
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[i]));
                    } else {
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                    }
                    InventoryGui.blit((int)(width / 2 + this.armorPosX[0][i]), (int)(height + this.armorPosY[i]), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
                }
                --i;
            }
            if (armType == InvConfig.ArmorType.FULL_AND_INV) {
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[6]));
                InventoryGui.blit((int)(width / 2 + this.armorPosX[0][6]), (int)(height + this.armorPosY[6]), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[7]));
                InventoryGui.blit((int)(width / 2 + this.armorPosX[0][7]), (int)(height + this.armorPosY[7]), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
                int count = 0;
                int arrows = 0;
                for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                    if (slot.func_190926_b()) {
                        ++count;
                    }
                    if (!this.isArrow(slot)) continue;
                    arrows += slot.func_190916_E();
                }
                this.fontRenderer.func_175063_a("" + count, (float)(width / 2 + this.armorPosX[1][6] + 23 - String.valueOf(count).length() * 6), (float)(height + this.armorPosY[6] + 4), 0xFFFFFF);
                this.fontRenderer.func_175063_a("" + arrows, (float)(width / 2 + this.armorPosX[1][7] - String.valueOf(arrows).length() * 6), (float)(height + this.armorPosY[7] + 4), 0xFFFFFF);
            }
            RenderSystem.popMatrix();
        } else {
            int x = 0;
            int y = 0;
            boolean right = false;
            switch (InventoryGui.ArmAligns.HorAlign) {
                case LEFT: {
                    x = armX;
                    break;
                }
                case MIDDLE: {
                    x = width / 2 - 45 - armX;
                    if (armX <= 0) break;
                    right = true;
                    break;
                }
                case RIGHT: {
                    x = width - armX;
                    right = true;
                }
            }
            switch (InventoryGui.ArmAligns.VertAlign) {
                case TOP: {
                    y = armY;
                    break;
                }
                case CENTER: {
                    y = height / 2 - 35 - armY;
                    break;
                }
                case BOTTOM: {
                    y = height - armY;
                }
            }
            if (x < 0) {
                x = 0;
            } else if (x > width - 90) {
                x = width - 90;
            }
            if (y < 0) {
                y = 0;
            } else if (y > height - 70) {
                y = height - 70;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)-320.0);
            this.RenderItems(0, 0, right);
            RenderSystem.popMatrix();
        }
    }

    private void RenderItems(int xpos, int ypos, boolean right) {
        int i = 5;
        int xOffset = right ? -42 : 42;
        int xOffset2 = right ? 75 : 0;
        for (ItemStack item : this.field_73839_d.field_71439_g.func_184209_aF()) {
            if (armType == InvConfig.ArmorType.ARMOR && i > 3) {
                --i;
                continue;
            }
            int Damage = ArmorStatus.GetDamage(item);
            if (Damage >= 0 && Damage <= armAbove) {
                String text = "";
                int tLength = -17;
                switch (armView) {
                    case PERCENTAGE: {
                        String p = String.valueOf(Damage);
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = (1 + p.length()) * 6 + 1;
                        break;
                    }
                    case DAMAGE: {
                        String p = String.valueOf(item.func_77952_i());
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = p.length() * 6 + 1;
                        break;
                    }
                    case DAMAGE_LEFT: {
                        String p = String.valueOf(item.func_77958_k() - item.func_77952_i());
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = p.length() * 6 + 1;
                        break;
                    }
                }
                if (i == 5) {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset + xOffset2, ypos);
                    RenderHelper.func_74518_a();
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength + xOffset + xOffset2), (float)(ypos + 4), 0xFFFFFF);
                } else if (i == 4) {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset + xOffset2, ypos + 18);
                    RenderHelper.func_74518_a();
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength + xOffset + xOffset2), (float)(ypos + 18 + 4), 0xFFFFFF);
                } else {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset2, ypos + i * 18);
                    RenderHelper.func_74518_a();
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength + xOffset2), (float)(ypos + i * 18 + 4), 0xFFFFFF);
                }
            } else if (Damage == -2 && armAbove == 100) {
                if (i == 5) {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset + xOffset2, ypos);
                    this.itemRenderer.func_175030_a(this.fontRenderer, item, xpos + xOffset + xOffset2, ypos);
                    RenderHelper.func_74518_a();
                } else if (i == 4) {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset + xOffset2, ypos + 18);
                    this.itemRenderer.func_175030_a(this.fontRenderer, item, xpos + xOffset + xOffset2, ypos + 18);
                    RenderHelper.func_74518_a();
                } else {
                    RenderHelper.func_227780_a_();
                    this.itemRenderer.func_180450_b(item, xpos + xOffset2, ypos + i * 18);
                    this.itemRenderer.func_175030_a(this.fontRenderer, item, xpos + xOffset2, ypos + i * 18);
                    RenderHelper.func_74518_a();
                }
            } else if (i == 5) {
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[i]));
                InventoryGui.blit((int)(xpos + xOffset + xOffset2), (int)ypos, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            } else if (i == 4) {
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                InventoryGui.blit((int)(xpos + xOffset + xOffset2), (int)(ypos + 18), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            } else {
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                InventoryGui.blit((int)(xpos + xOffset2), (int)(ypos + i * 18), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            }
            --i;
        }
        if (armType == InvConfig.ArmorType.FULL_AND_INV) {
            this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[6]));
            InventoryGui.blit((int)(xpos + xOffset + xOffset2), (int)(ypos + 36), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[7]));
            InventoryGui.blit((int)(xpos + xOffset + xOffset2), (int)(ypos + 54), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                if (slot.func_190926_b()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.func_190916_E();
            }
            int textOffset = right ? 1 + String.valueOf(count).length() * 6 : -17;
            int arOffset = right ? 1 + String.valueOf(arrows).length() * 6 : -17;
            this.fontRenderer.func_175063_a("" + count, (float)(xpos + xOffset - textOffset + xOffset2), (float)(ypos + 40), 0xFFFFFF);
            this.fontRenderer.func_175063_a("" + arrows, (float)(xpos + xOffset - arOffset + xOffset2), (float)(ypos + 58), 0xFFFFFF);
        }
    }

    private String getDamageText(String p, int d) {
        String result = p;
        if (d == 100) {
            result = TextFormatting.GREEN + result;
        } else if (d < 1) {
            result = TextFormatting.DARK_RED + result;
        } else if (d <= 10) {
            result = TextFormatting.RED + result;
        } else if (d <= 25) {
            result = TextFormatting.GOLD + result;
        } else if (d <= 50) {
            result = TextFormatting.YELLOW + result;
        }
        if (armView == InvConfig.ArmorView.PERCENTAGE) {
            result = result + TextFormatting.WHITE + "%";
        }
        return result;
    }

    private void RenderPotions(int width, int height) {
        int y = 0;
        int effCount = this.field_73839_d.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        PotionSpriteUploader potionspriteuploader = this.field_73839_d.func_213248_ap();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        int xPos = 0;
        int yPos = 0;
        switch (InventoryGui.PotAligns.HorAlign) {
            case LEFT: {
                xPos = potX;
                break;
            }
            case MIDDLE: {
                if (!potMini) {
                    xPos = width / 2 - 30 - potX;
                    break;
                }
                if (potX > 0) {
                    xPos = width / 2 - potX;
                    break;
                }
                if (potX < 0) {
                    xPos = width / 2 - 22 - potX;
                    break;
                }
                xPos = width / 2 - 11 - potX;
                break;
            }
            case RIGHT: {
                xPos = !potMini ? width - potX : width - potX + 23;
            }
        }
        switch (InventoryGui.PotAligns.VertAlign) {
            case TOP: {
                yPos = potY;
                break;
            }
            case CENTER: {
                if (!potMini) {
                    if (potY > 0) {
                        yPos = height / 2 - 12 - potY;
                        break;
                    }
                    if (potY < 0) {
                        yPos = height / 2 - 12 - (effCount - 1) * (24 + potGap) - potY;
                        break;
                    }
                    yPos = (int)((float)(height / 2 - 12) - (float)(effCount - 1) * ((float)potGap / 2.0f + 12.0f) - (float)potY);
                    break;
                }
                if (potY > 0) {
                    yPos = height / 2 - 9 - potY;
                    break;
                }
                if (potY < 0) {
                    yPos = height / 2 - 9 - (effCount - 1) * (18 + potGap) - potY;
                    break;
                }
                yPos = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)potGap / 2.0f + 9.0f) - (float)potY);
                break;
            }
            case BOTTOM: {
                yPos = !potMini ? height - potY - (effCount - 1) * (potGap + 24) : height - potY - (effCount - 1) * (potGap + 18);
            }
        }
        for (EffectInstance effect : this.field_73839_d.field_71439_g.func_70651_bq()) {
            Effect pot = effect.func_188419_a();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)potAlpha);
            if (!potMini) {
                this.field_73839_d.func_110434_K().func_110577_a(PBG);
                InventoryGui.blit((int)xPos, (int)(yPos + y), (float)60.0f, (float)24.0f, (int)60, (int)24, (int)(60 * potSide), (int)24);
            } else {
                this.field_73839_d.func_110434_K().func_110577_a(PBGM);
                InventoryGui.blit((int)xPos, (int)(yPos + y), (float)22.0f, (float)18.0f, (int)22, (int)18, (int)(22 * potSide), (int)18);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(pot);
            this.field_73839_d.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            if (!potMini) {
                InventoryGui.blit((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (int)this.getBlitOffset(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            } else {
                InventoryGui.blit((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (int)this.getBlitOffset(), (int)12, (int)12, (TextureAtlasSprite)textureatlassprite);
            }
            ResourceLocation lev = effect.func_76458_c() < 9 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.field_73839_d.func_110434_K().func_110577_a(lev);
            if (!potMini) {
                InventoryGui.blit((int)(xPos + 15 + potIconSide), (int)(yPos + y), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            } else {
                InventoryGui.blit((int)(xPos + 9 + potIconSide), (int)(yPos + y), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            }
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (!potMini) {
                if (dur > 1600) {
                    time = " **:**";
                } else {
                    String mins = dur / 60 + "";
                    String secs = dur % 60 + "";
                    if (dur / 60 < 10) {
                        mins = "0" + mins;
                    }
                    if (dur % 60 < 10) {
                        secs = "0" + secs;
                    }
                    time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
                }
                this.fontRenderer.func_175063_a(time, (float)(xPos + 28 + potTextSide), (float)(yPos + y + 8), 0xFFFFFF);
                y += 24 + potGap;
                continue;
            }
            int ysize = 12;
            this.field_73839_d.func_110434_K().func_110577_a(PMT);
            RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (dur < 300) {
                float r = 1.0f;
                float g = 1.0f;
                ysize = dur / 25 + 1;
                if (dur < 150) {
                    g = 0.006666667f * (float)dur;
                } else {
                    r = 0.006666667f * (float)(300 - dur);
                }
                RenderSystem.color4f((float)r, (float)g, (float)0.0f, (float)1.0f);
            }
            InventoryGui.blit((int)(xPos + 17 + potTextSide), (int)(yPos + y + 15 - ysize), (float)3.0f, (float)ysize, (int)3, (int)ysize, (int)3, (int)ysize);
            y += 18 + potGap;
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public static void PotPosChanged() {
        switch (InventoryGui.PotAligns.HorAlign) {
            case RIGHT: {
                if (!potMini) {
                    potSide = -1;
                    potIconSide = 36;
                    potTextSide = -22;
                    break;
                }
                potSide = -1;
                potIconSide = 4;
                potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (potX > 0) {
                    if (!potMini) {
                        potSide = -1;
                        potIconSide = 36;
                        potTextSide = -22;
                        break;
                    }
                    potSide = -1;
                    potIconSide = 4;
                    potTextSide = -15;
                    break;
                }
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
                break;
            }
            case LEFT: {
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
            }
        }
    }

    public static void PotPosYChanged(boolean top) {
        potVert = top ? 1 : -1;
    }

    static {
        armorRL = new String[]{"textures/item/empty_armor_slot_helmet.png", "textures/item/empty_armor_slot_chestplate.png", "textures/item/empty_armor_slot_leggings.png", "textures/item/empty_armor_slot_boots.png", "textures/item/empty_armor_slot_shield.png", "textures/item/empty_main_hand_slot.png", "textures/item/inventory.png", "textures/item/arrows.png"};
        PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");
        PBGM = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini.png");
        PMT = new ResourceLocation("inventoryhud", "textures/gui/potminitime.png");
    }
}

