/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.filter;

import com.terraforged.core.cell.Cell;

public interface Modifier {
    public float getModifier(float var1);

    default public float modify(Cell cell, float value) {
        return value * this.getModifier(cell.value);
    }

    default public Modifier invert() {
        return v -> 1.0f - this.getModifier(v);
    }

    public static Modifier range(final float minValue, final float maxValue) {
        return new Modifier(){
            private final float min;
            private final float max;
            private final float range;
            {
                this.min = minValue;
                this.max = maxValue;
                this.range = maxValue - minValue;
            }

            @Override
            public float getModifier(float value) {
                if (value > this.max) {
                    return 1.0f;
                }
                if (value < this.min) {
                    return 0.0f;
                }
                return (value - this.min) / this.range;
            }
        };
    }
}

