/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.module;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.module.Select;
import com.terraforged.core.world.climate.Climate;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.func.Interpolation;
import me.dags.noise.util.NoiseUtil;

public class MultiBlender
extends Select
implements Populator {
    private final Climate climate;
    private final Populator lower;
    private final Populator middle;
    private final Populator upper;
    private final float midpoint;
    private final float blendLower;
    private final float blendUpper;
    private final float lowerRange;
    private final float upperRange;

    public MultiBlender(Climate climate, Populator control, Populator lower, Populator middle, Populator upper, float min, float mid, float max) {
        super(control);
        this.climate = climate;
        this.lower = lower;
        this.upper = upper;
        this.middle = middle;
        this.midpoint = mid;
        this.blendLower = min;
        this.blendUpper = max;
        this.lowerRange = this.midpoint - this.blendLower;
        this.upperRange = this.blendUpper - this.midpoint;
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float y) {
        float select = this.getSelect(cell, x, y);
        if (select < this.blendLower) {
            this.lower.apply(cell, x, y);
            return;
        }
        if (select > this.blendUpper) {
            this.upper.apply(cell, x, y);
            return;
        }
        if (select < this.midpoint) {
            float alpha = Interpolation.CURVE3.apply((select - this.blendLower) / this.lowerRange);
            this.lower.apply(cell, x, y);
            float lowerVal = cell.value;
            Terrain lowerType = (Terrain)cell.tag;
            this.middle.apply(cell, x, y);
            float upperVal = cell.value;
            cell.value = NoiseUtil.lerp(lowerVal, upperVal, alpha);
        } else {
            float alpha = Interpolation.CURVE3.apply((select - this.midpoint) / this.upperRange);
            this.middle.apply(cell, x, y);
            float lowerVal = cell.value;
            this.upper.apply(cell, x, y);
            cell.value = NoiseUtil.lerp(lowerVal, cell.value, alpha);
        }
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float y) {
        float select = this.getSelect(cell, x, y);
        if (select < this.blendLower) {
            this.lower.tag(cell, x, y);
            return;
        }
        if (select > this.blendUpper) {
            this.upper.tag(cell, x, y);
            return;
        }
        if (select < this.midpoint) {
            this.lower.tag(cell, x, y);
            if (cell.value > ((Terrain)cell.tag).getMax(this.climate.getRand().getValue(x, y))) {
                this.upper.tag(cell, x, y);
            }
        } else {
            this.upper.tag(cell, x, y);
        }
    }
}

