/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;

@Serializable
public class FilterSettings {
    public Erosion erosion = new Erosion();
    public Smoothing smoothing = new Smoothing();

    @Serializable
    public static class Smoothing {
        @Range(min=0.0f, max=5.0f)
        @Comment(value={"Controls the number of smoothing iterations"})
        public int iterations = 1;
        @Range(min=0.0f, max=5.0f)
        @Comment(value={"Controls the smoothing radius"})
        public float smoothingRadius = 1.75f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how strongly smoothing is applied"})
        public float smoothingRate = 0.85f;
    }

    @Serializable
    public static class Erosion {
        @Range(min=1000.0f, max=50000.0f)
        @Comment(value={"Controls the number of erosion iterations"})
        public int iterations = 12000;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how quickly material dissolves (during erosion)"})
        public float erosionRate = 0.5f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how quickly material is deposited (during erosion)"})
        public float depositeRate = 0.2f;
    }
}

