/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.LongFunction;
import java.util.function.Predicate;

public class SynchronizedLongMap<V> {
    private final Object lock;
    private final Long2ObjectOpenHashMap<V> map;

    public SynchronizedLongMap(int size) {
        this.map = new Long2ObjectOpenHashMap(size);
        this.lock = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long key, V v) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(long key, LongFunction<V> func) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.computeIfAbsent(key, func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIf(Predicate<V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            ObjectIterator iterator = this.map.long2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                if (!predicate.test(((Long2ObjectMap.Entry)iterator.next()).getValue())) continue;
                iterator.remove();
            }
        }
    }
}

