/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.points;

import com.terraforged.core.region.Region;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.util.Vec2i;

public class Poisson {
    public static void main(String[] args) {
        Region region = new Region(0, 0, 5, 2);
        BufferedImage image = new BufferedImage(region.getBlockSize().size, region.getBlockSize().size, 1);
        Poisson.points(region, 123, 8, 20.0f, 0.8f);
        Poisson.render(region, image);
        JFrame frame = new JFrame();
        frame.add(new JLabel(new ImageIcon(image)));
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
    }

    private static void points(Region region, int seed, int scale, float radius, float threshold) {
        region.generate(chunk -> chunk.generate((cell, dx, dz) -> {}));
        Module noise = Source.simplex(seed, scale, 1);
        int gridSize = (int)Math.ceil((float)region.getBlockSize().size / radius);
        Vec2i[][] grid = new Vec2i[gridSize][gridSize];
        for (int dz = 0; dz < region.getBlockSize().size; ++dz) {
            for (int dx = 0; dx < region.getBlockSize().size; ++dx) {
                float value;
                int x = region.getBlockX() + dx;
                int z = region.getBlockZ() + dz;
                region.getCell((int)dx, (int)dz).value = value = noise.getValue(x, z);
            }
        }
    }

    private static void render(Region region, BufferedImage image) {
        region.iterate((cell, dx, dz) -> {
            if (cell.value == 0.0f) {
                return;
            }
            int w = (int)(cell.value * 255.0f);
            image.setRGB(dx, dz, new Color(w, w, w).getRGB());
        });
    }
}

