/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.serialization.serializer;

import com.terraforged.core.util.serialization.annotation.Serializable;
import com.terraforged.core.util.serialization.serializer.Reader;
import com.terraforged.core.util.serialization.serializer.Serializer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class Deserializer {
    public void deserialize(Reader reader, Object object) throws Throwable {
        Class<?> type = object.getClass();
        for (String name : reader.getKeys()) {
            if (name.charAt(0) == '#') continue;
            try {
                Reader child = reader.getChild(name);
                Field field = type.getField(name);
                if (!Serializer.isSerializable(field)) continue;
                field.setAccessible(true);
                this.fromValue(child, object, field);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private void fromValue(Reader reader, Object object, Field field) throws Throwable {
        Class<?> type;
        if (field.getType() == Integer.TYPE) {
            field.set(object, reader.getInt("value"));
            return;
        }
        if (field.getType() == Float.TYPE) {
            field.set(object, Float.valueOf(reader.getFloat("value")));
            return;
        }
        if (field.getType() == Boolean.TYPE) {
            field.set(object, reader.getString("value").equals("true"));
            return;
        }
        if (field.getType() == String.class) {
            field.set(object, reader.getString("value"));
            return;
        }
        if (field.getType().isEnum()) {
            String name = reader.getString("value");
            for (Enum e : field.getType().asSubclass(Enum.class).getEnumConstants()) {
                if (!e.name().equals(name)) continue;
                field.set(object, e);
                return;
            }
        }
        if (field.getType().isAnnotationPresent(Serializable.class)) {
            Reader child = reader.getChild("value");
            Object value = field.getType().newInstance();
            this.deserialize(child, value);
            field.set(object, value);
            return;
        }
        if (field.getType().isArray() && (type = field.getType().getComponentType()).isAnnotationPresent(Serializable.class)) {
            Reader child = reader.getChild("value");
            Object array = Array.newInstance(type, child.getSize());
            for (int i = 0; i < child.getSize(); ++i) {
                Object value = type.newInstance();
                this.deserialize(child.getChild(i), value);
                Array.set(array, i, value);
            }
            field.set(object, array);
        }
    }

    private static String getName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                c = Character.toLowerCase(c);
            } else if (c == ' ' && i + 1 < name.length()) {
                c = Character.toUpperCase(name.charAt(++i));
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

