/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.biome;

import com.terraforged.core.world.biome.BiomeType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import me.dags.noise.util.NoiseUtil;

public class BiomeTypeLoader {
    private static BiomeTypeLoader instance;
    private final float[][] edges = new float[256][256];
    private final BiomeType[][] map = new BiomeType[256][256];

    public BiomeTypeLoader() {
        this.generateTypeMap();
        this.generateEdgeMap();
    }

    public BiomeType[][] getTypeMap() {
        return this.map;
    }

    public float[][] getEdgeMap() {
        return this.edges;
    }

    private BiomeType getType(int x, int y) {
        return this.map[y][x];
    }

    private void generateTypeMap() {
        try {
            BufferedImage image = ImageIO.read(BiomeType.class.getResourceAsStream("/biomes.png"));
            float xf = (float)image.getWidth() / 256.0f;
            float yf = (float)image.getHeight() / 256.0f;
            for (int y = 0; y < 256; ++y) {
                for (int x = 0; x < 256; ++x) {
                    if (255 - y > x) {
                        this.map[255 - y][x] = BiomeType.ALPINE;
                        continue;
                    }
                    int ix = NoiseUtil.round((float)x * xf);
                    int iy = NoiseUtil.round((float)y * yf);
                    int argb = image.getRGB(ix, iy);
                    Color color = BiomeTypeLoader.fromARGB(argb);
                    this.map[255 - y][x] = BiomeTypeLoader.forColor(color);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateEdgeMap() {
        BiomeType type;
        int x;
        int y;
        int[] distances = new int[BiomeType.values().length];
        for (y = 0; y < 256; ++y) {
            for (x = 0; x < 256; ++x) {
                if (y > x || (type = this.getType(x, y)) == BiomeType.ALPINE) continue;
                int distance2 = this.getEdge(x, y, type);
                this.edges[y][x] = distance2;
                distances[type.ordinal()] = Math.max(distances[type.ordinal()], distance2);
            }
        }
        for (y = 0; y < 256; ++y) {
            for (x = 0; x < 256; ++x) {
                type = this.getType(x, y);
                int max = distances[type.ordinal()];
                float distance = this.edges[y][x];
                float value = NoiseUtil.pow(distance / (float)max, 0.33f);
                this.edges[y][x] = NoiseUtil.clamp(value, 0.0f, 1.0f);
            }
        }
    }

    private int getEdge(int cx, int cy, BiomeType type) {
        int radius = 64;
        int distance2 = Integer.MAX_VALUE;
        int x0 = Math.max(0, cx - radius);
        int x1 = Math.min(255, cx + radius);
        int y0 = Math.max(0, cy - radius);
        int y1 = Math.min(255, cy + radius);
        for (int y = y0; y <= y1; ++y) {
            for (int x = x0; x <= x1; ++x) {
                int dist2;
                BiomeType neighbour = this.getType(x, y);
                if (neighbour == BiomeType.ALPINE || neighbour == type || (dist2 = BiomeTypeLoader.dist2(cx, cy, x, y)) >= distance2) continue;
                distance2 = dist2;
            }
        }
        return distance2;
    }

    private static BiomeType forColor(Color color) {
        BiomeType type = null;
        int closest = Integer.MAX_VALUE;
        for (BiomeType t : BiomeType.values()) {
            int distance2 = BiomeTypeLoader.getDistance2(color, t.getLookup());
            if (distance2 >= closest) continue;
            closest = distance2;
            type = t;
        }
        if (type == null) {
            return BiomeType.GRASSLAND;
        }
        return type;
    }

    private static int getDistance2(Color a, Color b) {
        int dr = a.getRed() - b.getRed();
        int dg = a.getGreen() - b.getGreen();
        int db = a.getBlue() - b.getBlue();
        return dr * dr + dg * dg + db * db;
    }

    private static Color fromARGB(int argb) {
        int b = argb & 0xFF;
        int g = argb >> 8 & 0xFF;
        int r = argb >> 16 & 0xFF;
        return new Color(r, g, b);
    }

    private static int dist2(int x1, int y1, int x2, int y2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private static BufferedImage generateEdgeMapImage() {
        BufferedImage image = new BufferedImage(256, 256, 1);
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                float temperature = (float)x / 256.0f;
                float moisture = (float)y / 256.0f;
                float value = BiomeType.getEdge(temperature, moisture);
                int color = Color.HSBtoRGB(0.0f, 0.0f, value);
                image.setRGB(x, image.getHeight() - 1 - y, color);
            }
        }
        return image;
    }

    public static BiomeTypeLoader getInstance() {
        if (instance == null) {
            instance = new BiomeTypeLoader();
        }
        return instance;
    }

    public static void main(String[] args) throws Throwable {
        BufferedImage img = BiomeTypeLoader.generateEdgeMapImage();
        ImageIO.write((RenderedImage)img, "png", new File("biomes_dist.png"));
        JLabel label = new JLabel(new ImageIcon(img));
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(label);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

